/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.resolver.impl.maven;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.jboss.shrinkwrap.resolver.api.NoResolvedResultException;
import org.jboss.shrinkwrap.resolver.api.NonUniqueResultException;
import org.jboss.shrinkwrap.resolver.api.formatprocessor.FileFormatProcessor;
import org.jboss.shrinkwrap.resolver.api.formatprocessor.FormatProcessor;
import org.jboss.shrinkwrap.resolver.api.formatprocessor.InputStreamFormatProcessor;
import org.jboss.shrinkwrap.resolver.api.maven.MavenFormatStage;
import org.jboss.shrinkwrap.resolver.api.maven.ResolvedArtifactInfo;
import org.jboss.shrinkwrap.resolver.impl.maven.util.IOUtil;
import org.jboss.shrinkwrap.resolver.impl.maven.util.Validate;
import org.sonatype.aether.artifact.Artifact;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
public class MavenFormatStageImpl
implements MavenFormatStage {
    private static final Logger log = Logger.getLogger(MavenFormatStageImpl.class.getName());
    private static final ArtifactMapper REACTOR_MAPPER = new ArtifactMapper(){

        public File map(Artifact artifact) throws IllegalArgumentException {
            Validate.notNull(artifact, "ArtifactResult must not be null");
            if (!this.isMappable(artifact)) {
                throw new IllegalArgumentException(MessageFormat.format("Artifact {0} cannot be mapped to a file.", artifact));
            }
            if ("pom.xml".equals(artifact.getFile().getName())) {
                String artifactId = artifact.getArtifactId();
                String extension = artifact.getExtension();
                File root = new File(artifact.getFile().getParentFile(), "target/classes");
                try {
                    File archive = File.createTempFile(artifactId + "-", "." + extension);
                    archive.deleteOnExit();
                    PackageDirHelper.packageDirectories(archive, root);
                    return archive;
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("Unable to get artifact " + artifactId + " from the classpath", e);
                }
            }
            return artifact.getFile();
        }

        public boolean isMappable(Artifact artifactResult) throws IllegalArgumentException {
            return true;
        }
    };
    private final Collection<Artifact> artifacts;

    public MavenFormatStageImpl(Collection<Artifact> artifacts) {
        assert (artifacts != null) : "Artifacts are required";
        this.artifacts = artifacts;
    }

    public final File[] as(Class<File> type) throws IllegalArgumentException {
        return this.as((Class)File.class, (FormatProcessor)FileFormatProcessor.INSTANCE);
    }

    public final InputStream[] as(Class<InputStream> type) throws IllegalArgumentException {
        return this.as((Class)InputStream.class, (FormatProcessor)InputStreamFormatProcessor.INSTANCE);
    }

    public final File asSingle(Class<File> type) throws IllegalArgumentException, NonUniqueResultException, NoResolvedResultException {
        return this.asSingle((Class)File.class, (FormatProcessor)FileFormatProcessor.INSTANCE);
    }

    public final InputStream asSingle(Class<InputStream> type) throws IllegalArgumentException, NonUniqueResultException, NoResolvedResultException {
        return this.asSingle((Class)InputStream.class, (FormatProcessor)InputStreamFormatProcessor.INSTANCE);
    }

    public final <RETURNTYPE> RETURNTYPE[] as(Class<RETURNTYPE> type, FormatProcessor<RETURNTYPE> processor) throws IllegalArgumentException {
        ArrayList<Object> list = new ArrayList<Object>();
        for (Artifact artifact : this.artifacts) {
            if (REACTOR_MAPPER.isMappable(artifact)) {
                list.add(processor.process(REACTOR_MAPPER.map(artifact)));
                continue;
            }
            log.log(Level.INFO, "Removed artifact {0} from archive, it cannot be mapped to a file", artifact);
        }
        Object[] array = (Object[])Array.newInstance(type, list.size());
        for (int i = 0; i < list.size(); ++i) {
            array[i] = list.get(i);
        }
        return array;
    }

    public final <RETURNTYPE> RETURNTYPE asSingle(Class<RETURNTYPE> type, FormatProcessor<RETURNTYPE> processor) throws IllegalArgumentException, NonUniqueResultException, NoResolvedResultException {
        ArrayList<Object> collection = new ArrayList<Object>();
        for (Artifact artifact : this.artifacts) {
            if (REACTOR_MAPPER.isMappable(artifact)) {
                collection.add(processor.process(REACTOR_MAPPER.map(artifact)));
                continue;
            }
            log.log(Level.INFO, "Removed artifact {0} from archive, it cannot be mapped to a file", artifact);
        }
        if (collection.isEmpty()) {
            throw new NoResolvedResultException("Unable to resolve dependencies, none of them were found.");
        }
        if (collection.size() != 1) {
            StringBuilder sb = new StringBuilder();
            for (Object e : collection) {
                sb.append(e).append("\n");
            }
            if (sb.lastIndexOf("\n") != -1) {
                sb.deleteCharAt(sb.length() - 1);
            }
            throw new NonUniqueResultException(MessageFormat.format("Resolution resolved more than a single artifact ({0} artifact(s)), unable to determine which one should used.\nComplete list of resolved artifacts:\n{1}", collection.size(), sb));
        }
        return (RETURNTYPE)collection.iterator().next();
    }

    public final ResolvedArtifactInfo[] as(Class<ResolvedArtifactInfo> type) throws IllegalArgumentException {
        throw new UnsupportedOperationException();
    }

    public final ResolvedArtifactInfo asSingle(Class<ResolvedArtifactInfo> type) throws IllegalArgumentException, NonUniqueResultException, NoResolvedResultException {
        throw new UnsupportedOperationException();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PackageDirHelper {
        private PackageDirHelper() {
            throw new UnsupportedOperationException("No instances should be created; stateless class");
        }

        private static void safelyClose(Closeable closeable) {
            block3: {
                if (closeable != null) {
                    try {
                        closeable.close();
                    }
                    catch (IOException ignore) {
                        if (!log.isLoggable(Level.FINER)) break block3;
                        log.finer("Could not close stream due to: " + ignore.getMessage() + "; ignoring");
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static void packageDirectories(File outputFile, File ... directories) throws IOException {
            Validate.notNullAndNoNullValues(directories, "Directories to be packaged must be specified");
            ZipOutputStream zipFile = new ZipOutputStream(new FileOutputStream(outputFile));
            for (File directory : directories) {
                for (String entry : PackageDirHelper.fileListing(directory)) {
                    FileInputStream fis = null;
                    try {
                        fis = new FileInputStream(new File(directory, entry));
                        zipFile.putNextEntry(new ZipEntry(entry));
                        IOUtil.copy(fis, zipFile);
                    }
                    catch (Throwable throwable) {
                        PackageDirHelper.safelyClose(fis);
                        throw throwable;
                    }
                    PackageDirHelper.safelyClose(fis);
                }
            }
            PackageDirHelper.safelyClose(zipFile);
        }

        private static List<String> fileListing(File directory) {
            ArrayList<String> list = new ArrayList<String>();
            PackageDirHelper.generateFileList(list, directory, directory);
            return list;
        }

        private static void generateFileList(List<String> list, File root, File file) {
            if (file.isFile()) {
                list.add(file.getAbsolutePath().substring(root.getAbsolutePath().length() + 1));
            } else if (file.isDirectory()) {
                for (File next : file.listFiles()) {
                    PackageDirHelper.generateFileList(list, root, next);
                }
            }
        }
    }

    private static interface ArtifactMapper {
        public boolean isMappable(Artifact var1) throws IllegalArgumentException;

        public File map(Artifact var1) throws IllegalArgumentException;
    }
}

