/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.resolver.impl.maven;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.shrinkwrap.resolver.api.ResolutionException;
import org.jboss.shrinkwrap.resolver.api.ResolutionStrategy;
import org.jboss.shrinkwrap.resolver.api.maven.MavenFormatStage;
import org.jboss.shrinkwrap.resolver.api.maven.MavenStrategyStageBase;
import org.jboss.shrinkwrap.resolver.api.maven.PomEquippedResolveStageBase;
import org.jboss.shrinkwrap.resolver.api.maven.ScopeType;
import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenDependency;
import org.jboss.shrinkwrap.resolver.api.maven.filter.ScopeFilter;
import org.jboss.shrinkwrap.resolver.api.maven.strategy.AcceptAllStrategy;
import org.jboss.shrinkwrap.resolver.api.maven.strategy.AcceptScopesStrategy;
import org.jboss.shrinkwrap.resolver.api.maven.strategy.CombinedStrategy;
import org.jboss.shrinkwrap.resolver.api.maven.strategy.MavenResolutionStrategy;
import org.jboss.shrinkwrap.resolver.impl.maven.MavenWorkingSession;
import org.jboss.shrinkwrap.resolver.impl.maven.ResolveStageBaseImpl;
import org.jboss.shrinkwrap.resolver.impl.maven.convert.MavenConverter;
import org.jboss.shrinkwrap.resolver.impl.maven.util.Validate;
import org.sonatype.aether.artifact.ArtifactTypeRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PomEquippedResolveStageBaseImpl<EQUIPPEDRESOLVESTAGETYPE extends PomEquippedResolveStageBase<EQUIPPEDRESOLVESTAGETYPE, STRATEGYSTAGETYPE, FORMATSTAGETYPE>, STRATEGYSTAGETYPE extends MavenStrategyStageBase<STRATEGYSTAGETYPE, FORMATSTAGETYPE>, FORMATSTAGETYPE extends MavenFormatStage>
extends ResolveStageBaseImpl<EQUIPPEDRESOLVESTAGETYPE, STRATEGYSTAGETYPE, FORMATSTAGETYPE>
implements PomEquippedResolveStageBase<EQUIPPEDRESOLVESTAGETYPE, STRATEGYSTAGETYPE, FORMATSTAGETYPE> {
    private static final Logger log = Logger.getLogger(PomEquippedResolveStageBaseImpl.class.getName());
    private static final List<MavenDependency> EMPTY_LIST = new ArrayList<MavenDependency>(0);

    public PomEquippedResolveStageBaseImpl(MavenWorkingSession session) {
        super(session);
        ArtifactTypeRegistry stereotypes = session.getArtifactTypeRegistry();
        Validate.stateNotNull(session.getModel(), "Could not spawn ConfiguredResolveStage. An effective POM must be resolved first.");
        if (session.getModel().getDependencyManagement() != null) {
            Set<MavenDependency> pomDependencyMngmt = MavenConverter.fromDependencies(session.getModel().getDependencyManagement().getDependencies(), stereotypes);
            session.getDependencyManagement().addAll(pomDependencyMngmt);
        }
        Set<MavenDependency> pomDefinedDependencies = MavenConverter.fromDependencies(session.getModel().getDependencies(), stereotypes);
        session.getDeclaredDependencies().addAll(pomDefinedDependencies);
        session.getDependencyManagement().addAll(pomDefinedDependencies);
    }

    public final FORMATSTAGETYPE importRuntimeAndTestDependencies() {
        this.addScopedDependencies(ScopeType.values());
        return this.importAnyDependencies((MavenResolutionStrategy)AcceptAllStrategy.INSTANCE);
    }

    public final FORMATSTAGETYPE importRuntimeAndTestDependencies(MavenResolutionStrategy strategy) throws IllegalArgumentException {
        Validate.notNull(strategy, "Specified strategy for importing test dependencies must not be null");
        this.addScopedDependencies(ScopeType.values());
        return this.importAnyDependencies(strategy);
    }

    public final FORMATSTAGETYPE importRuntimeDependencies() {
        ScopeType[] scopes = new ScopeType[]{ScopeType.COMPILE, ScopeType.IMPORT, ScopeType.RUNTIME, ScopeType.SYSTEM};
        this.addScopedDependencies(scopes);
        return this.importAnyDependencies((MavenResolutionStrategy)new AcceptScopesStrategy(scopes));
    }

    public final FORMATSTAGETYPE importRuntimeDependencies(MavenResolutionStrategy strategy) throws IllegalArgumentException {
        Validate.notNull(strategy, "Specified strategy for importing test dependencies must not be null");
        ScopeType[] scopes = new ScopeType[]{ScopeType.COMPILE, ScopeType.IMPORT, ScopeType.RUNTIME, ScopeType.SYSTEM};
        this.addScopedDependencies(scopes);
        AcceptScopesStrategy scopeStrategy = new AcceptScopesStrategy(scopes);
        CombinedStrategy combined = new CombinedStrategy(new MavenResolutionStrategy[]{scopeStrategy, strategy});
        return this.importAnyDependencies((MavenResolutionStrategy)combined);
    }

    private FORMATSTAGETYPE importAnyDependencies(MavenResolutionStrategy strategy) {
        return (FORMATSTAGETYPE)((MavenFormatStage)this.createStrategyStage().using((ResolutionStrategy)strategy));
    }

    private void addScopedDependencies(ScopeType ... scopes) {
        MavenWorkingSession session = this.getMavenWorkingSession();
        ArrayList<MavenDependency> dependencies = new ArrayList<MavenDependency>(session.getDeclaredDependencies());
        ScopeFilter preResolutionFilter = new ScopeFilter(scopes);
        for (MavenDependency candidate : dependencies) {
            if (!preResolutionFilter.accepts(candidate, EMPTY_LIST)) continue;
            session.getDependenciesForResolution().add(candidate);
        }
    }

    @Override
    protected String resolveVersion(MavenDependency dependency) throws IllegalArgumentException {
        String declaredVersion;
        String resolvedVersion = declaredVersion = dependency.getVersion();
        MavenWorkingSession session = this.getMavenWorkingSession();
        if (Validate.isNullOrEmpty(resolvedVersion) && session.getDependencyManagement().contains(dependency)) {
            MavenDependency resolved2 = null;
            for (MavenDependency resolved2 : session.getDependencyManagement()) {
                if (resolved2.equals(dependency)) break;
            }
            resolvedVersion = resolved2.getVersion();
            log.log(Level.FINE, "Resolved version {} from the POM file for the artifact {}", new Object[]{resolved2.getVersion(), dependency.toCanonicalForm()});
        }
        if (Validate.isNullOrEmpty(resolvedVersion)) {
            if (log.isLoggable(Level.FINER)) {
                StringBuilder sb = new StringBuilder("Available version management: \n");
                for (MavenDependency depmgmt : session.getDependencyManagement()) {
                    sb.append(depmgmt).append("\n");
                }
                log.log(Level.FINER, sb.toString());
            }
            throw new ResolutionException(MessageFormat.format("Unable to get version for dependency specified by {0}, it was not provided in <dependencyManagement> section.", dependency.toCanonicalForm()));
        }
        return resolvedVersion;
    }
}

