/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.resolver.impl.maven.bootstrap;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.maven.settings.Settings;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.resolution.DependencyResolutionException;
import org.eclipse.aether.resolution.DependencyResult;
import org.eclipse.aether.resolution.VersionRangeRequest;
import org.eclipse.aether.resolution.VersionRangeResolutionException;
import org.eclipse.aether.resolution.VersionRangeResult;
import org.jboss.shrinkwrap.resolver.api.maven.MavenWorkingSession;
import org.jboss.shrinkwrap.resolver.api.maven.filter.MavenResolutionFilter;
import org.jboss.shrinkwrap.resolver.impl.maven.bootstrap.MavenManagerBuilder;
import org.jboss.shrinkwrap.resolver.impl.maven.bootstrap.MavenResolutionFilterWrap;
import org.jboss.shrinkwrap.resolver.impl.maven.bootstrap.SecurityActions;
import org.jboss.shrinkwrap.resolver.impl.maven.bootstrap.ShrinkWrapResolverServiceLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MavenRepositorySystem {
    private final RepositorySystem system = this.getRepositorySystem();

    public DefaultRepositorySystemSession getSession(Settings settings) {
        DefaultRepositorySystemSession session = new DefaultRepositorySystemSession();
        MavenManagerBuilder builder = new MavenManagerBuilder(this.system, settings);
        session.setLocalRepositoryManager(builder.localRepositoryManager((RepositorySystemSession)session));
        session.setWorkspaceReader(builder.workspaceReader());
        session.setTransferListener(builder.transferListerer());
        session.setRepositoryListener(builder.repositoryListener());
        session.setOffline(settings.isOffline());
        session.setMirrorSelector(builder.mirrorSelector());
        session.setProxySelector(builder.proxySelector());
        session.setDependencyManager(builder.dependencyManager());
        session.setArtifactDescriptorPolicy(builder.artifactRepositoryPolicy());
        session.setDependencyTraverser(builder.dependencyTraverser());
        session.setDependencyGraphTransformer(builder.dependencyGraphTransformer());
        session.setArtifactTypeRegistry(builder.artifactTypeRegistry());
        session.setSystemProperties((Map)SecurityActions.getProperties());
        session.setConfigProperties((Map)SecurityActions.getProperties());
        return session;
    }

    public Collection<ArtifactResult> resolveDependencies(RepositorySystemSession repoSession, MavenWorkingSession swrSession, CollectRequest request, MavenResolutionFilter[] filters) throws DependencyResolutionException {
        DependencyRequest depRequest = new DependencyRequest(request, (DependencyFilter)new MavenResolutionFilterWrap(filters, Collections.unmodifiableList(new ArrayList(swrSession.getDependenciesForResolution()))));
        DependencyResult result = this.system.resolveDependencies(repoSession, depRequest);
        return result.getArtifactResults();
    }

    public ArtifactResult resolveArtifact(RepositorySystemSession session, ArtifactRequest request) throws ArtifactResolutionException {
        return this.system.resolveArtifact(session, request);
    }

    public VersionRangeResult resolveVersionRange(RepositorySystemSession session, VersionRangeRequest request) throws VersionRangeResolutionException {
        return this.system.resolveVersionRange(session, request);
    }

    private RepositorySystem getRepositorySystem() throws UnsupportedOperationException {
        ShrinkWrapResolverServiceLocator locator = new ShrinkWrapResolverServiceLocator();
        return locator.getService(RepositorySystem.class);
    }
}

