/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.resolver.impl.maven.bootstrap;

import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SecurityActions {
    private SecurityActions() {
        throw new UnsupportedOperationException("No instantiation");
    }

    static String getProperty(final String key) {
        try {
            String value = AccessController.doPrivileged(new PrivilegedExceptionAction<String>(){

                @Override
                public String run() {
                    return System.getProperty(key);
                }
            });
            return value;
        }
        catch (PrivilegedActionException pae) {
            Throwable t = pae.getCause();
            if (t instanceof SecurityException) {
                throw (SecurityException)t;
            }
            if (t instanceof NullPointerException) {
                throw (NullPointerException)t;
            }
            if (t instanceof IllegalArgumentException) {
                throw (IllegalArgumentException)t;
            }
            try {
                throw (RuntimeException)t;
            }
            catch (ClassCastException cce) {
                throw new RuntimeException("Obtained unchecked Exception; this code should never be reached", t);
            }
        }
    }

    static String getEnvProperty(final String key) {
        try {
            String value = AccessController.doPrivileged(new PrivilegedExceptionAction<String>(){

                @Override
                public String run() {
                    return System.getenv(key);
                }
            });
            return value;
        }
        catch (PrivilegedActionException pae) {
            Throwable t = pae.getCause();
            if (t instanceof SecurityException) {
                throw (SecurityException)t;
            }
            if (t instanceof NullPointerException) {
                throw (NullPointerException)t;
            }
            if (t instanceof IllegalArgumentException) {
                throw (IllegalArgumentException)t;
            }
            try {
                throw (RuntimeException)t;
            }
            catch (ClassCastException cce) {
                throw new RuntimeException("Obtained unchecked Exception; this code should never be reached", t);
            }
        }
    }

    static Properties getProperties() {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Properties>(){

                @Override
                public Properties run() {
                    return System.getProperties();
                }
            });
        }
        catch (PrivilegedActionException pae) {
            Throwable t = pae.getCause();
            if (t instanceof SecurityException) {
                throw (SecurityException)t;
            }
            if (t instanceof NullPointerException) {
                throw (NullPointerException)t;
            }
            if (t instanceof IllegalArgumentException) {
                throw (IllegalArgumentException)t;
            }
            try {
                throw (RuntimeException)t;
            }
            catch (ClassCastException cce) {
                throw new RuntimeException("Obtained unchecked Exception; this code should never be reached", t);
            }
        }
    }

    static <T> T newInstance(Class<T> implClass, Class<?>[] argumentTypes, Object[] arguments) {
        T obj;
        if (implClass == null) {
            throw new IllegalArgumentException("ImplClass must be specified");
        }
        if (argumentTypes == null) {
            throw new IllegalArgumentException("ArgumentTypes must be specified. Use empty array if no arguments");
        }
        if (arguments == null) {
            throw new IllegalArgumentException("Arguments must be specified. Use empty array if no arguments");
        }
        try {
            Constructor<T> constructor = SecurityActions.getConstructor(implClass, argumentTypes);
            if (!constructor.isAccessible()) {
                constructor.setAccessible(true);
            }
            obj = constructor.newInstance(arguments);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create new instance of " + implClass, e);
        }
        return obj;
    }

    static <T> Constructor<T> getConstructor(final Class<T> clazz, final Class<?> ... argumentTypes) throws NoSuchMethodException {
        try {
            return (Constructor)AccessController.doPrivileged(new PrivilegedExceptionAction<Constructor<T>>(){

                @Override
                public Constructor<T> run() throws NoSuchMethodException {
                    return clazz.getDeclaredConstructor(argumentTypes);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            Throwable t = pae.getCause();
            if (t instanceof NoSuchMethodException) {
                throw (NoSuchMethodException)t;
            }
            try {
                throw (RuntimeException)t;
            }
            catch (ClassCastException cce) {
                throw new RuntimeException("Obtained unchecked Exception; this code should never be reached", t);
            }
        }
    }
}

