/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.resolver.impl.maven;

import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.maven.settings.Settings;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.jboss.shrinkwrap.resolver.api.InvalidConfigurationFileException;
import org.jboss.shrinkwrap.resolver.api.maven.MavenWorkingSession;
import org.jboss.shrinkwrap.resolver.impl.maven.SettingsManager;
import org.jboss.shrinkwrap.resolver.impl.maven.bootstrap.MavenRepositorySystem;

public abstract class ConfigurableMavenWorkingSessionImpl
implements MavenWorkingSession {
    private static final Logger log = Logger.getLogger(ConfigurableMavenWorkingSessionImpl.class.getName());
    private DefaultRepositorySystemSession session;
    private SettingsManager settingsManager;
    private boolean useLegacyLocalRepository = false;
    private final MavenRepositorySystem system = new MavenRepositorySystem();
    private boolean disableClassPathWorkspaceReader = false;

    public ConfigurableMavenWorkingSessionImpl() {
        this.settingsManager = new SettingsManager();
    }

    public MavenWorkingSession configureSettingsFromFile(File globalSettings, File userSettings) throws InvalidConfigurationFileException {
        this.settingsManager.configureSettingsFromFile(globalSettings, userSettings);
        return this.regenerateSession();
    }

    public MavenWorkingSession regenerateSession() {
        this.generateSession();
        return this;
    }

    public void setOffline(boolean offline) {
        if (log.isLoggable(Level.FINER)) {
            log.finer("Set offline mode programatically to: " + offline);
        }
        this.settingsManager.setOffline(offline);
        this.regenerateSessionIfNotNull();
    }

    public void disableClassPathWorkspaceReader() {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Disabling ClassPath resolution");
        }
        this.disableClassPathWorkspaceReader = true;
        this.regenerateSessionIfNotNull();
    }

    public void useLegacyLocalRepository(boolean useLegacyLocalRepository) {
        if (this.useLegacyLocalRepository == useLegacyLocalRepository) {
            return;
        }
        log.log(Level.FINEST, "Using legacy local repository");
        this.useLegacyLocalRepository = useLegacyLocalRepository;
        this.regenerateSessionIfNotNull();
    }

    protected DefaultRepositorySystemSession getSession() {
        if (this.session == null) {
            this.generateSession();
        }
        return this.session;
    }

    protected Settings getSettings() {
        return this.settingsManager.getSettings();
    }

    protected boolean isOffline() {
        return this.settingsManager.isOffline();
    }

    protected MavenRepositorySystem getSystem() {
        return this.system;
    }

    private void regenerateSessionIfNotNull() {
        if (this.session != null) {
            this.regenerateSession();
        }
    }

    private void generateSession() {
        this.session = this.system.getSession(this.getSettings(), this.useLegacyLocalRepository);
        if (this.disableClassPathWorkspaceReader) {
            this.session.setWorkspaceReader(null);
        }
    }
}

