/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.resolver.impl.maven.internal.decrypt;

import java.io.File;
import java.util.ArrayList;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.building.DefaultSettingsProblem;
import org.apache.maven.settings.building.SettingsProblem;
import org.apache.maven.settings.crypto.SettingsDecrypter;
import org.apache.maven.settings.crypto.SettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecryptionResult;
import org.jboss.shrinkwrap.resolver.impl.maven.internal.decrypt.MavenSecurityDispatcher;
import org.jboss.shrinkwrap.resolver.impl.maven.internal.decrypt.MavenSettingsDecryptionResult;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcher;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcherException;

public class MavenSettingsDecrypter
implements SettingsDecrypter {
    private SecDispatcher securityDispatcher;

    public MavenSettingsDecrypter(File securitySettings) {
        this.securityDispatcher = new MavenSecurityDispatcher(securitySettings);
    }

    public SettingsDecryptionResult decrypt(SettingsDecryptionRequest request) {
        ArrayList<SettingsProblem> problems = new ArrayList<SettingsProblem>();
        ArrayList<Server> servers = new ArrayList<Server>();
        for (Server server : request.getServers()) {
            server = server.clone();
            servers.add(server);
            try {
                server.setPassword(this.decrypt(server.getPassword()));
            }
            catch (SecDispatcherException e) {
                problems.add((SettingsProblem)new DefaultSettingsProblem("Failed to decrypt password for server " + server.getId() + ": " + e.getMessage(), SettingsProblem.Severity.ERROR, "server: " + server.getId(), -1, -1, (Exception)((Object)e)));
            }
            try {
                server.setPassphrase(this.decrypt(server.getPassphrase()));
            }
            catch (SecDispatcherException e) {
                problems.add((SettingsProblem)new DefaultSettingsProblem("Failed to decrypt passphrase for server " + server.getId() + ": " + e.getMessage(), SettingsProblem.Severity.ERROR, "server: " + server.getId(), -1, -1, (Exception)((Object)e)));
            }
        }
        ArrayList<Proxy> proxies = new ArrayList<Proxy>();
        for (Proxy proxy : request.getProxies()) {
            proxy = proxy.clone();
            proxies.add(proxy);
            try {
                proxy.setPassword(this.decrypt(proxy.getPassword()));
            }
            catch (SecDispatcherException e) {
                problems.add((SettingsProblem)new DefaultSettingsProblem("Failed to decrypt password for proxy " + proxy.getId() + ": " + e.getMessage(), SettingsProblem.Severity.ERROR, "proxy: " + proxy.getId(), -1, -1, (Exception)((Object)e)));
            }
        }
        return new MavenSettingsDecryptionResult(servers, proxies, problems);
    }

    private String decrypt(String str) throws SecDispatcherException {
        return str == null ? null : this.securityDispatcher.decrypt(str);
    }
}

