/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.maven.wagon.providers.http;

import shaded.org.apache.maven.wagon.ConnectionException;
import shaded.org.apache.maven.wagon.authentication.AuthenticationException;
import shaded.org.apache.maven.wagon.providers.http.LightweightHttpWagon;
import shaded.org.apache.maven.wagon.proxy.ProxyInfo;

public class LightweightHttpsWagon
extends LightweightHttpWagon {
    private String previousHttpsProxyHost;
    private String previousHttpsProxyPort;
    private String previousHttpsProxyExclusions;

    @Override
    public void openConnection() throws ConnectionException, AuthenticationException {
        this.previousHttpsProxyHost = System.getProperty("https.proxyHost");
        this.previousHttpsProxyPort = System.getProperty("https.proxyPort");
        this.previousHttpsProxyExclusions = System.getProperty("https.nonProxyHosts");
        ProxyInfo proxyInfo = this.getProxyInfo("https", this.getRepository().getHost());
        if (proxyInfo != null) {
            this.setSystemProperty("https.proxyHost", proxyInfo.getHost());
            this.setSystemProperty("https.proxyPort", String.valueOf(proxyInfo.getPort()));
            this.setSystemProperty("https.nonProxyHosts", proxyInfo.getNonProxyHosts());
        } else {
            this.setSystemProperty("https.proxyHost", null);
            this.setSystemProperty("https.proxyPort", null);
        }
        super.openConnection();
    }

    @Override
    public void closeConnection() throws ConnectionException {
        super.closeConnection();
        this.setSystemProperty("https.proxyHost", this.previousHttpsProxyHost);
        this.setSystemProperty("https.proxyPort", this.previousHttpsProxyPort);
        this.setSystemProperty("https.nonProxyHosts", this.previousHttpsProxyExclusions);
    }
}

