/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.eclipse.aether.internal.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import shaded.javax.inject.Inject;
import shaded.javax.inject.Named;
import shaded.org.eclipse.aether.RepositorySystemSession;
import shaded.org.eclipse.aether.internal.impl.PrioritizedComponent;
import shaded.org.eclipse.aether.internal.impl.PrioritizedComponents;
import shaded.org.eclipse.aether.internal.impl.Utils;
import shaded.org.eclipse.aether.repository.RemoteRepository;
import shaded.org.eclipse.aether.spi.connector.transport.Transporter;
import shaded.org.eclipse.aether.spi.connector.transport.TransporterFactory;
import shaded.org.eclipse.aether.spi.connector.transport.TransporterProvider;
import shaded.org.eclipse.aether.spi.locator.Service;
import shaded.org.eclipse.aether.spi.locator.ServiceLocator;
import shaded.org.eclipse.aether.transfer.NoTransporterException;
import shaded.org.slf4j.Logger;
import shaded.org.slf4j.LoggerFactory;

@Named
public final class DefaultTransporterProvider
implements TransporterProvider,
Service {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultTransporterProvider.class);
    private Collection<TransporterFactory> factories = new ArrayList<TransporterFactory>();

    public DefaultTransporterProvider() {
    }

    @Inject
    DefaultTransporterProvider(Set<TransporterFactory> transporterFactories) {
        this.setTransporterFactories(transporterFactories);
    }

    @Override
    public void initService(ServiceLocator locator) {
        this.setTransporterFactories(locator.getServices(TransporterFactory.class));
    }

    public DefaultTransporterProvider addTransporterFactory(TransporterFactory factory) {
        this.factories.add(Objects.requireNonNull(factory, "transporter factory cannot be null"));
        return this;
    }

    public DefaultTransporterProvider setTransporterFactories(Collection<TransporterFactory> factories) {
        this.factories = factories == null ? new ArrayList<TransporterFactory>() : factories;
        return this;
    }

    @Override
    public Transporter newTransporter(RepositorySystemSession session, RemoteRepository repository) throws NoTransporterException {
        Objects.requireNonNull(repository, "remote repository cannot be null");
        PrioritizedComponents<TransporterFactory> factories = new PrioritizedComponents<TransporterFactory>(session);
        for (TransporterFactory factory : this.factories) {
            factories.add(factory, factory.getPriority());
        }
        ArrayList<NoTransporterException> errors = new ArrayList<NoTransporterException>();
        for (PrioritizedComponent factory : factories.getEnabled()) {
            try {
                Transporter transporter = ((TransporterFactory)factory.getComponent()).newInstance(session, repository);
                if (LOGGER.isDebugEnabled()) {
                    StringBuilder buffer = new StringBuilder(256);
                    buffer.append("Using transporter ").append(transporter.getClass().getSimpleName());
                    Utils.appendClassLoader(buffer, transporter);
                    buffer.append(" with priority ").append(factory.getPriority());
                    buffer.append(" for ").append(repository.getUrl());
                    LOGGER.debug(buffer.toString());
                }
                return transporter;
            }
            catch (NoTransporterException noTransporterException) {
                errors.add(noTransporterException);
            }
        }
        if (LOGGER.isDebugEnabled() && errors.size() > 1) {
            String msg = "Could not obtain transporter factory for " + repository;
            for (Exception exception : errors) {
                LOGGER.debug(msg, exception);
            }
        }
        StringBuilder buffer = new StringBuilder(256);
        if (factories.isEmpty()) {
            buffer.append("No transporter factories registered");
        } else {
            buffer.append("Cannot access ").append(repository.getUrl());
            buffer.append(" using the registered transporter factories: ");
            factories.list(buffer);
        }
        throw new NoTransporterException(repository, buffer.toString(), errors.size() == 1 ? (NoTransporterException)errors.get(0) : null);
    }
}

