/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.eclipse.aether.internal.transport.wagon;

import java.util.Objects;
import shaded.javax.inject.Inject;
import shaded.javax.inject.Named;
import shaded.javax.inject.Singleton;
import shaded.org.apache.maven.wagon.Wagon;
import shaded.org.codehaus.plexus.PlexusContainer;
import shaded.org.codehaus.plexus.classworlds.realm.ClassRealm;
import shaded.org.codehaus.plexus.component.configurator.AbstractComponentConfigurator;
import shaded.org.codehaus.plexus.component.configurator.ComponentConfigurationException;
import shaded.org.codehaus.plexus.component.configurator.ConfigurationListener;
import shaded.org.codehaus.plexus.component.configurator.converters.composite.ObjectWithFieldsConverter;
import shaded.org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import shaded.org.codehaus.plexus.configuration.PlexusConfiguration;
import shaded.org.codehaus.plexus.configuration.xml.XmlPlexusConfiguration;
import shaded.org.codehaus.plexus.util.xml.Xpp3Dom;
import shaded.org.eclipse.aether.transport.wagon.WagonConfigurator;

@Named(value="plexus")
@Singleton
public class PlexusWagonConfigurator
implements WagonConfigurator {
    private PlexusContainer container;

    @Inject
    public PlexusWagonConfigurator(PlexusContainer container) {
        this.container = Objects.requireNonNull(container, "plexus container cannot be null");
    }

    @Override
    public void configure(Wagon wagon, Object configuration) throws Exception {
        PlexusConfiguration config;
        if (configuration instanceof PlexusConfiguration) {
            config = (PlexusConfiguration)configuration;
        } else if (configuration instanceof Xpp3Dom) {
            config = new XmlPlexusConfiguration((Xpp3Dom)configuration);
        } else {
            if (configuration == null) {
                return;
            }
            throw new IllegalArgumentException("unexpected configuration type: " + configuration.getClass().getName());
        }
        WagonComponentConfigurator configurator = new WagonComponentConfigurator();
        configurator.configureComponent(wagon, config, this.container.getContainerRealm());
    }

    static class WagonComponentConfigurator
    extends AbstractComponentConfigurator {
        WagonComponentConfigurator() {
        }

        public void configureComponent(Object component, PlexusConfiguration configuration, ExpressionEvaluator expressionEvaluator, ClassRealm containerRealm, ConfigurationListener listener) throws ComponentConfigurationException {
            ObjectWithFieldsConverter converter = new ObjectWithFieldsConverter();
            converter.processConfiguration(this.converterLookup, component, (ClassLoader)containerRealm, configuration, expressionEvaluator, listener);
        }
    }
}

