/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.jboss.shrinkwrap.resolver.api.maven.repository;

import java.net.MalformedURLException;
import java.net.URL;
import shaded.org.jboss.shrinkwrap.resolver.api.maven.repository.MavenChecksumPolicy;
import shaded.org.jboss.shrinkwrap.resolver.api.maven.repository.MavenRemoteRepository;
import shaded.org.jboss.shrinkwrap.resolver.api.maven.repository.MavenUpdatePolicy;

class MavenRemoteRepositoryImpl
implements MavenRemoteRepository {
    String id;
    String layout;
    URL url;
    MavenUpdatePolicy upPolicy = null;
    MavenChecksumPolicy ckPolicy = null;

    MavenRemoteRepositoryImpl(String id, String url, String layout) throws MalformedURLException {
        this(id, new URL(url), layout);
    }

    MavenRemoteRepositoryImpl(String id, URL url, String layout) {
        if (id == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        if (url == null) {
            throw new IllegalArgumentException("url cannot be null");
        }
        if (layout == null) {
            throw new IllegalArgumentException("layout cannot be null");
        }
        if (!layout.equals("default")) {
            throw new IllegalArgumentException("layout must be default. Parameter reserved for later use");
        }
        this.id = id;
        this.layout = layout;
        this.url = url;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getType() {
        return this.layout;
    }

    @Override
    public String getUrl() {
        return this.url.toString();
    }

    @Override
    public MavenUpdatePolicy getUpdatePolicy() {
        return this.upPolicy;
    }

    @Override
    public MavenChecksumPolicy getChecksumPolicy() {
        return this.ckPolicy;
    }

    @Override
    public MavenRemoteRepository setUpdatePolicy(MavenUpdatePolicy policy) {
        this.upPolicy = policy;
        return this;
    }

    @Override
    public MavenRemoteRepository setChecksumPolicy(MavenChecksumPolicy policy) {
        this.ckPolicy = policy;
        return this;
    }
}

