/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.jboss.shrinkwrap.resolver.impl.maven.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import shaded.org.apache.maven.model.Profile;
import shaded.org.apache.maven.model.building.ModelProblemCollector;
import shaded.org.apache.maven.model.path.DefaultPathTranslator;
import shaded.org.apache.maven.model.profile.ProfileActivationContext;
import shaded.org.apache.maven.model.profile.ProfileSelector;
import shaded.org.apache.maven.model.profile.activation.FileProfileActivator;
import shaded.org.apache.maven.model.profile.activation.JdkVersionProfileActivator;
import shaded.org.apache.maven.model.profile.activation.OperatingSystemProfileActivator;
import shaded.org.apache.maven.model.profile.activation.ProfileActivator;
import shaded.org.apache.maven.model.profile.activation.PropertyProfileActivator;
import shaded.org.jboss.shrinkwrap.resolver.impl.maven.util.Validate;

public class SettingsXmlProfileSelector
implements ProfileSelector {
    private final List<ProfileActivator> activators = new ArrayList<ProfileActivator>();

    public SettingsXmlProfileSelector() {
        this.activators.addAll(Arrays.asList(new JdkVersionProfileActivator(), new PropertyProfileActivator(), new OperatingSystemProfileActivator(), new FileProfileActivator().setPathTranslator(new DefaultPathTranslator())));
    }

    @Override
    public List<Profile> getActiveProfiles(Collection<Profile> profiles, ProfileActivationContext context, ModelProblemCollector problems) {
        ArrayList<Profile> activeProfiles = new ArrayList<Profile>();
        block0: for (Profile p : profiles) {
            String id = p.getId();
            if (p.getId() != null && context.getActiveProfileIds().contains(id) && !context.getInactiveProfileIds().contains(id)) {
                activeProfiles.add(p);
                continue;
            }
            if (p.getActivation() != null && p.getActivation().isActiveByDefault() && !context.getInactiveProfileIds().contains(p.getId())) {
                activeProfiles.add(p);
                continue;
            }
            for (ProfileActivator activator : this.activators) {
                if (!activator.isActive(p, context, problems)) continue;
                activeProfiles.add(p);
                continue block0;
            }
        }
        return activeProfiles;
    }

    public static List<String> explicitlyActivatedProfiles(String ... profiles) {
        if (profiles.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<String> activated = new ArrayList<String>();
        for (String profileId : profiles) {
            Validate.notNullOrEmpty(profileId, "Invalid name (\"" + profileId + "\") of a profile to be activated");
            if (profileId.startsWith("-") || profileId.startsWith("!")) continue;
            activated.add(profileId);
        }
        return activated;
    }

    public static List<String> explicitlyDisabledProfiles(String ... profiles) {
        if (profiles.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<String> disabled = new ArrayList<String>();
        for (String profileId : profiles) {
            if (profileId == null || !profileId.startsWith("-") && !profileId.startsWith("!")) continue;
            String disabledId = profileId.substring(1);
            Validate.notNullOrEmpty(disabledId, "Invalid name (\"" + profileId + "\") of a profile do be disabled");
            disabled.add(disabledId);
        }
        return disabled;
    }
}

