/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.jboss.shrinkwrap.resolver.impl.maven.internal.decrypt;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import shaded.org.sonatype.plexus.components.cipher.PBECipher;
import shaded.org.sonatype.plexus.components.cipher.PlexusCipher;
import shaded.org.sonatype.plexus.components.cipher.PlexusCipherException;

public class MavenPlexusCipher
implements PlexusCipher {
    private static final Pattern ENCRYPTED_PATTERN_WITH_PRECEDING_STRING = Pattern.compile("[^\\\\$]\\{(.*?[^\\\\])\\}.*", 32);
    private static final Pattern ENCRYPTED_PATTERN_WITHOUT_PRECEDING_STRING = Pattern.compile("^\\{(.*?[^\\\\])\\}.*", 40);
    private final PBECipher cipher;

    public MavenPlexusCipher() throws IllegalStateException {
        try {
            this.cipher = new PBECipher();
        }
        catch (PlexusCipherException e) {
            throw new IllegalStateException("Unable to instantiate Cipher to decrypt Maven passwords");
        }
    }

    @Override
    public String encrypt(String str, String passPhrase) throws PlexusCipherException {
        if (str == null || str.length() < 1) {
            return str;
        }
        return this.cipher.encrypt64(str, passPhrase);
    }

    @Override
    public String encryptAndDecorate(String str, String passPhrase) throws PlexusCipherException {
        return this.decorate(this.encrypt(str, passPhrase));
    }

    @Override
    public String decrypt(String str, String passPhrase) throws PlexusCipherException {
        if (str == null || str.length() < 1) {
            return str;
        }
        return this.cipher.decrypt64(str, passPhrase);
    }

    @Override
    public String decryptDecorated(String str, String passPhrase) throws PlexusCipherException {
        if (str == null || str.length() < 1) {
            return str;
        }
        if (this.isEncryptedString(str)) {
            return this.decrypt(this.unDecorate(str), passPhrase);
        }
        return this.decrypt(str, passPhrase);
    }

    @Override
    public boolean isEncryptedString(String str) {
        if (str == null || str.length() < 1) {
            return false;
        }
        Matcher matcherWithPrecString = ENCRYPTED_PATTERN_WITH_PRECEDING_STRING.matcher(str);
        Matcher matcherWithoutPrecString = ENCRYPTED_PATTERN_WITHOUT_PRECEDING_STRING.matcher(str);
        return matcherWithoutPrecString.matches() || matcherWithoutPrecString.find() || matcherWithPrecString.matches() || matcherWithPrecString.find();
    }

    @Override
    public String unDecorate(String str) throws PlexusCipherException {
        Matcher matcherWithoutPrecString = ENCRYPTED_PATTERN_WITHOUT_PRECEDING_STRING.matcher(str);
        if (matcherWithoutPrecString.matches() || matcherWithoutPrecString.find()) {
            return matcherWithoutPrecString.group(1);
        }
        Matcher matcherWithPrecString = ENCRYPTED_PATTERN_WITH_PRECEDING_STRING.matcher(str);
        if (matcherWithPrecString.matches() || matcherWithPrecString.find()) {
            return matcherWithPrecString.group(1);
        }
        throw new IllegalStateException("Unable to undecorate decrypted string " + str);
    }

    @Override
    public String decorate(String str) {
        return '{' + (str == null ? "" : str) + '}';
    }
}

