/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.mima.context;

import eu.maveniverse.maven.mima.context.ContextOverrides;
import eu.maveniverse.maven.mima.context.internal.RuntimeSupport;
import java.io.Closeable;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import shaded.org.eclipse.aether.RepositorySystem;
import shaded.org.eclipse.aether.RepositorySystemSession;
import shaded.org.eclipse.aether.repository.RemoteRepository;

public final class Context
implements Closeable {
    private final RuntimeSupport runtime;
    private final ContextOverrides contextOverrides;
    private final RepositorySystem repositorySystem;
    private final RepositorySystemSession repositorySystemSession;
    private final List<RemoteRepository> remoteRepositories;
    private final Runnable managedCloser;

    public Context(RuntimeSupport runtime, ContextOverrides contextOverrides, RepositorySystem repositorySystem, RepositorySystemSession repositorySystemSession, List<RemoteRepository> remoteRepositories, Runnable managedCloser) {
        this.runtime = Objects.requireNonNull(runtime);
        this.contextOverrides = Objects.requireNonNull(contextOverrides);
        this.repositorySystemSession = Objects.requireNonNull(repositorySystemSession);
        this.repositorySystem = Objects.requireNonNull(repositorySystem);
        this.remoteRepositories = Objects.requireNonNull(remoteRepositories);
        this.managedCloser = managedCloser;
    }

    public ContextOverrides contextOverrides() {
        return this.contextOverrides;
    }

    public Path basedir() {
        return this.contextOverrides.getBasedir();
    }

    public ContextOverrides.MavenUserHome mavenUserHome() {
        return this.contextOverrides.getMavenUserHome();
    }

    public ContextOverrides.MavenSystemHome mavenSystemHome() {
        return this.contextOverrides.getMavenSystemHome();
    }

    public RepositorySystemSession repositorySystemSession() {
        return this.repositorySystemSession;
    }

    public RepositorySystem repositorySystem() {
        return this.repositorySystem;
    }

    public List<RemoteRepository> remoteRepositories() {
        return this.remoteRepositories;
    }

    public Context customize(ContextOverrides overrides) {
        return this.runtime.customizeContext(overrides, this, false);
    }

    @Override
    public void close() {
        if (this.managedCloser != null) {
            this.managedCloser.run();
        }
    }
}

