/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.google.common.io;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import shaded.com.google.common.annotations.GwtIncompatible;
import shaded.com.google.common.base.Preconditions;
import shaded.com.google.common.io.ByteStreams;
import shaded.com.google.common.io.CharSink;
import shaded.com.google.common.io.Closer;
import shaded.com.google.common.io.ElementTypesAreNonnullByDefault;
import shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;

@ElementTypesAreNonnullByDefault
@GwtIncompatible
public abstract class ByteSink {
    protected ByteSink() {
    }

    public CharSink asCharSink(Charset charset) {
        return new AsCharSink(charset);
    }

    public abstract OutputStream openStream() throws IOException;

    public OutputStream openBufferedStream() throws IOException {
        OutputStream out = this.openStream();
        return out instanceof BufferedOutputStream ? (BufferedOutputStream)out : new BufferedOutputStream(out);
    }

    public void write(byte[] bytes) throws IOException {
        Preconditions.checkNotNull(bytes);
        try (Closer closer = Closer.create();){
            OutputStream out = closer.register(this.openStream());
            out.write(bytes);
            out.flush();
        }
    }

    @CanIgnoreReturnValue
    public long writeFrom(InputStream input) throws IOException {
        Preconditions.checkNotNull(input);
        try (Closer closer = Closer.create();){
            OutputStream out = closer.register(this.openStream());
            long written = ByteStreams.copy(input, out);
            out.flush();
            long l = written;
            return l;
        }
    }

    private final class AsCharSink
    extends CharSink {
        private final Charset charset;

        private AsCharSink(Charset charset) {
            this.charset = Preconditions.checkNotNull(charset);
        }

        @Override
        public Writer openStream() throws IOException {
            return new OutputStreamWriter(ByteSink.this.openStream(), this.charset);
        }

        public String toString() {
            String string = ByteSink.this.toString();
            String string2 = String.valueOf(this.charset);
            return new StringBuilder(13 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(".asCharSink(").append(string2).append(")").toString();
        }
    }
}

