/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.eclipse.aether.internal.impl.checksum;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import shaded.javax.inject.Inject;
import shaded.javax.inject.Named;
import shaded.javax.inject.Singleton;
import shaded.org.eclipse.aether.RepositorySystemSession;
import shaded.org.eclipse.aether.artifact.Artifact;
import shaded.org.eclipse.aether.repository.RemoteRepository;
import shaded.org.eclipse.aether.spi.checksums.TrustedChecksumsSource;
import shaded.org.eclipse.aether.spi.connector.ArtifactDownload;
import shaded.org.eclipse.aether.spi.connector.checksum.ChecksumAlgorithmFactory;
import shaded.org.eclipse.aether.spi.connector.checksum.ProvidedChecksumsSource;

@Singleton
@Named(value="trusted2provided")
public final class TrustedToProvidedChecksumsSourceAdapter
implements ProvidedChecksumsSource {
    public static final String NAME = "trusted2provided";
    private final Map<String, TrustedChecksumsSource> trustedChecksumsSources;

    @Inject
    public TrustedToProvidedChecksumsSourceAdapter(Map<String, TrustedChecksumsSource> trustedChecksumsSources) {
        this.trustedChecksumsSources = Objects.requireNonNull(trustedChecksumsSources);
    }

    @Override
    public Map<String, String> getProvidedArtifactChecksums(RepositorySystemSession session, ArtifactDownload transfer, List<ChecksumAlgorithmFactory> checksumAlgorithmFactories) {
        Artifact artifact = transfer.getArtifact();
        for (RemoteRepository remoteRepository : transfer.getRepositories()) {
            for (TrustedChecksumsSource trustedChecksumsSource : this.trustedChecksumsSources.values()) {
                Map<String, String> trustedChecksums = trustedChecksumsSource.getTrustedArtifactChecksums(session, artifact, remoteRepository, checksumAlgorithmFactories);
                if (trustedChecksums == null || trustedChecksums.isEmpty()) continue;
                return trustedChecksums;
            }
        }
        return null;
    }
}

