/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.eclipse.aether.named.support;

import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import shaded.org.eclipse.aether.named.NamedLockFactory;
import shaded.org.eclipse.aether.named.support.NamedLockSupport;
import shaded.org.slf4j.Logger;
import shaded.org.slf4j.LoggerFactory;

public abstract class NamedLockFactorySupport
implements NamedLockFactory {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ConcurrentMap<String, NamedLockHolder> locks = new ConcurrentHashMap<String, NamedLockHolder>();

    @Override
    public NamedLockSupport getLock(String name) {
        return this.locks.compute(name, (k, v) -> {
            if (v == null) {
                v = new NamedLockHolder(this.createLock((String)k));
            }
            ((NamedLockHolder)v).incRef();
            return v;
        }).namedLock;
    }

    @Override
    public void shutdown() {
    }

    public void closeLock(String name) {
        this.locks.compute(name, (k, v) -> {
            if (v != null && ((NamedLockHolder)v).decRef() == 0) {
                this.destroyLock(((NamedLockHolder)v).namedLock.name());
                return null;
            }
            return v;
        });
    }

    protected abstract NamedLockSupport createLock(String var1);

    protected void destroyLock(String name) {
    }

    private static final class NamedLockHolder {
        private final NamedLockSupport namedLock;
        private final AtomicInteger referenceCount;

        private NamedLockHolder(NamedLockSupport namedLock) {
            this.namedLock = Objects.requireNonNull(namedLock);
            this.referenceCount = new AtomicInteger(0);
        }

        private int incRef() {
            return this.referenceCount.incrementAndGet();
        }

        private int decRef() {
            return this.referenceCount.decrementAndGet();
        }

        public String toString() {
            return "[refCount=" + this.referenceCount.get() + ", lock=" + this.namedLock + "]";
        }
    }
}

