/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.eclipse.sisu.inject;

import shaded.com.google.inject.Binding;
import shaded.com.google.inject.Injector;
import shaded.com.google.inject.Key;
import shaded.com.google.inject.TypeLiteral;
import shaded.org.eclipse.sisu.Hidden;
import shaded.org.eclipse.sisu.inject.BindingPublisher;
import shaded.org.eclipse.sisu.inject.InjectorBindings;
import shaded.org.eclipse.sisu.inject.Logs;
import shaded.org.eclipse.sisu.inject.Sources;
import shaded.org.eclipse.sisu.inject.TypeArguments;

final class ImplicitBindings {
    private final Iterable<BindingPublisher> publishers;

    ImplicitBindings(Iterable<BindingPublisher> publishers) {
        this.publishers = publishers;
    }

    public <T> Binding<T> get(TypeLiteral<T> type) {
        Key<T> implicitKey = TypeArguments.implicitKey(type.getRawType());
        for (BindingPublisher p : this.publishers) {
            Injector i;
            Binding<?> binding;
            if (!(p instanceof InjectorBindings) || (binding = (i = ((InjectorBindings)p).getInjector()).getBindings().get(implicitKey)) == null) continue;
            Logs.trace("Using implicit binding: {} from: <>", binding, i);
            return binding;
        }
        Key<T> justInTimeKey = Key.get(type);
        for (BindingPublisher p : this.publishers) {
            if (!(p instanceof InjectorBindings)) continue;
            Injector i = ((InjectorBindings)p).getInjector();
            try {
                Binding<T> binding = i.getBinding(justInTimeKey);
                if (Sources.getAnnotation(binding, Hidden.class) != null) continue;
                Logs.trace("Using just-in-time binding: {} from: <>", binding, i);
                return binding;
            }
            catch (RuntimeException e) {
                Logs.trace("Problem with just-in-time binding: {}", justInTimeKey, e);
            }
            catch (LinkageError e) {
                Logs.trace("Problem with just-in-time binding: {}", justInTimeKey, e);
            }
        }
        return null;
    }
}

