/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.eclipse.sisu.launch;

import java.util.Collections;
import java.util.Map;
import shaded.com.google.inject.Binder;
import shaded.com.google.inject.Guice;
import shaded.com.google.inject.Injector;
import shaded.com.google.inject.Module;
import shaded.com.google.inject.Provides;
import shaded.javax.inject.Inject;
import shaded.org.eclipse.sisu.Parameters;
import shaded.org.eclipse.sisu.inject.MutableBeanLocator;
import shaded.org.eclipse.sisu.space.BeanScanning;
import shaded.org.eclipse.sisu.space.ClassSpace;
import shaded.org.eclipse.sisu.space.SpaceModule;
import shaded.org.eclipse.sisu.space.URLClassSpace;
import shaded.org.eclipse.sisu.wire.ParameterKeys;
import shaded.org.eclipse.sisu.wire.WireModule;

public final class Main
implements Module {
    private final Map<?, ?> properties;
    private final String[] args;

    private Main(Map<?, ?> properties, String ... args) {
        this.properties = Collections.unmodifiableMap(properties);
        this.args = args;
    }

    public static void main(String ... args) {
        Main.boot(System.getProperties(), args);
    }

    public static <T> T boot(Class<T> type, String ... args) {
        return Main.boot(System.getProperties(), args).getInstance(type);
    }

    public static Injector boot(Map<?, ?> properties, String ... args) {
        BeanScanning scanning = BeanScanning.select(properties);
        Module app = Main.wire(scanning, new Main(properties, args));
        Injector injector = Guice.createInjector(app);
        return injector;
    }

    public static Module wire(BeanScanning scanning, Module ... bindings) {
        Module[] modules = new Module[bindings.length + 1];
        System.arraycopy(bindings, 0, modules, 0, bindings.length);
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        modules[bindings.length] = new SpaceModule((ClassSpace)new URLClassSpace(tccl), scanning);
        return new WireModule(modules);
    }

    @Override
    public void configure(Binder binder) {
        binder.bind(ParameterKeys.PROPERTIES).toInstance(this.properties);
        binder.bind(ShutdownThread.class).asEagerSingleton();
    }

    @Provides
    @Parameters
    String[] parameters() {
        return (String[])this.args.clone();
    }

    static final class ShutdownThread
    extends Thread {
        private final MutableBeanLocator locator;

        @Inject
        ShutdownThread(MutableBeanLocator locator) {
            this.locator = locator;
            Runtime.getRuntime().addShutdownHook(this);
        }

        @Override
        public void run() {
            this.locator.clear();
        }
    }
}

