/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.eclipse.sisu.plexus;

import java.lang.annotation.Annotation;
import shaded.com.google.inject.Key;
import shaded.com.google.inject.Singleton;
import shaded.com.google.inject.TypeLiteral;
import shaded.com.google.inject.name.Named;
import shaded.com.google.inject.name.Names;
import shaded.javax.inject.Inject;
import shaded.org.eclipse.sisu.inject.BeanLocator;
import shaded.org.eclipse.sisu.plexus.DefaultPlexusBeans;
import shaded.org.eclipse.sisu.plexus.HintedPlexusBeans;
import shaded.org.eclipse.sisu.plexus.PlexusBean;
import shaded.org.eclipse.sisu.plexus.PlexusBeanLocator;
import shaded.org.eclipse.sisu.plexus.RealmFilteredBeans;

@Singleton
public final class DefaultPlexusBeanLocator
implements PlexusBeanLocator {
    private final BeanLocator beanLocator;
    private final String visibility;

    @Inject
    public DefaultPlexusBeanLocator(BeanLocator beanLocator) {
        this(beanLocator, null);
    }

    public DefaultPlexusBeanLocator(BeanLocator beanLocator, String visibility) {
        this.beanLocator = beanLocator;
        this.visibility = visibility;
    }

    @Override
    public <T> Iterable<PlexusBean<T>> locate(TypeLiteral<T> role, String ... hints) {
        Key<T> key = hints.length == 1 ? Key.get(role, (Annotation)Names.named(hints[0])) : Key.get(role, Named.class);
        Iterable beans = this.beanLocator.locate(key);
        if ("realm".equalsIgnoreCase(this.visibility)) {
            beans = new RealmFilteredBeans(beans);
        }
        return hints.length <= 1 ? new DefaultPlexusBeans(beans) : new HintedPlexusBeans(beans, role, hints);
    }
}

