/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.eclipse.sisu.plexus;

import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import shaded.com.google.inject.Guice;
import shaded.com.google.inject.Module;
import shaded.org.eclipse.sisu.inject.BindingPublisher;
import shaded.org.eclipse.sisu.inject.InjectorBindings;
import shaded.org.eclipse.sisu.inject.MutableBeanLocator;
import shaded.org.eclipse.sisu.launch.BundleModule;
import shaded.org.eclipse.sisu.launch.BundlePlan;
import shaded.org.eclipse.sisu.plexus.PlexusSpaceModule;
import shaded.org.eclipse.sisu.space.BeanScanning;

public class PlexusBundlePlan
implements BundlePlan {
    private static final String SUPPORT_BUNDLE_NAME = FrameworkUtil.getBundle(PlexusSpaceModule.class).getSymbolicName();
    protected final MutableBeanLocator locator;

    public PlexusBundlePlan(MutableBeanLocator locator) {
        this.locator = locator;
    }

    @Override
    public BindingPublisher prepare(Bundle bundle) {
        if (!SUPPORT_BUNDLE_NAME.equals(bundle.getSymbolicName()) && (PlexusBundlePlan.hasPlexusAnnotations(bundle) || PlexusBundlePlan.hasPlexusXml(bundle))) {
            return new InjectorBindings(Guice.createInjector(new BundleModule(bundle, this.locator){

                @Override
                protected Module spaceModule() {
                    return new PlexusSpaceModule(this.space, BeanScanning.select(this.getProperties()));
                }
            }));
        }
        return null;
    }

    protected static boolean hasPlexusAnnotations(Bundle bundle) {
        String imports = (String)bundle.getHeaders().get("Import-Package");
        return imports != null && imports.contains("shaded.org.codehaus.plexus.component.annotations");
    }

    protected static boolean hasPlexusXml(Bundle bundle) {
        return bundle.findEntries("META-INF/plexus", "components.xml", false) != null;
    }
}

