/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.eclipse.sisu.space;

import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import shaded.com.google.inject.Binder;
import shaded.com.google.inject.Key;
import shaded.com.google.inject.Module;
import shaded.com.google.inject.PrivateBinder;
import shaded.com.google.inject.spi.Element;
import shaded.com.google.inject.spi.Elements;
import shaded.com.google.inject.spi.MembersInjectorLookup;
import shaded.com.google.inject.spi.PrivateElements;
import shaded.com.google.inject.spi.ProviderLookup;
import shaded.org.eclipse.sisu.space.BeanScanning;
import shaded.org.eclipse.sisu.space.ClassFinder;
import shaded.org.eclipse.sisu.space.ClassSpace;
import shaded.org.eclipse.sisu.space.IndexedClassFinder;
import shaded.org.eclipse.sisu.space.QualifiedTypeBinder;
import shaded.org.eclipse.sisu.space.QualifiedTypeVisitor;
import shaded.org.eclipse.sisu.space.SpaceScanner;
import shaded.org.eclipse.sisu.space.SpaceVisitor;

public final class SpaceModule
implements Module {
    private static final String NAMED_INDEX = "META-INF/sisu/javax.inject.Named";
    public static final ClassFinder LOCAL_INDEX = new IndexedClassFinder("META-INF/sisu/javax.inject.Named", false);
    public static final ClassFinder GLOBAL_INDEX = new IndexedClassFinder("META-INF/sisu/javax.inject.Named", true);
    public static final ClassFinder LOCAL_SCAN = SpaceScanner.DEFAULT_FINDER;
    private final boolean caching;
    private final ClassSpace space;
    private final ClassFinder finder;
    private Strategy strategy = Strategy.DEFAULT;

    public SpaceModule(ClassSpace space) {
        this(space, BeanScanning.ON);
    }

    public SpaceModule(ClassSpace space, ClassFinder finder) {
        this.caching = false;
        this.space = space;
        this.finder = finder;
    }

    public SpaceModule(ClassSpace space, BeanScanning scanning) {
        this.caching = BeanScanning.CACHE == scanning;
        this.space = space;
        switch (scanning) {
            case OFF: {
                this.finder = null;
                break;
            }
            case INDEX: {
                this.finder = LOCAL_INDEX;
                break;
            }
            case GLOBAL_INDEX: {
                this.finder = GLOBAL_INDEX;
                break;
            }
            default: {
                this.finder = LOCAL_SCAN;
            }
        }
    }

    public Module with(Strategy _strategy) {
        this.strategy = _strategy;
        return this;
    }

    @Override
    public void configure(Binder binder) {
        binder.bind(ClassSpace.class).toInstance(this.space);
        if (this.caching) {
            this.recordAndReplayElements(binder);
        } else if (this.finder != null) {
            this.scanForElements(binder);
        }
    }

    void scanForElements(Binder binder) {
        new SpaceScanner(this.space, this.finder).accept(this.strategy.visitor(binder));
    }

    private void recordAndReplayElements(Binder binder) {
        List<Element> recording;
        String key = this.space.toString();
        List<Element> elements = (List<Element>)RecordedElements.cache.get(key);
        if (elements == null && (elements = RecordedElements.cache.putIfAbsent(key, recording = Elements.getElements(new Module(){

            @Override
            public void configure(Binder recorder) {
                SpaceModule.this.scanForElements(recorder);
            }
        }))) == null) {
            Elements.getModule(recording).configure(binder);
            return;
        }
        SpaceModule.replayRecordedElements(binder, elements);
    }

    private static void replayRecordedElements(Binder binder, List<Element> elements) {
        for (Element e : elements) {
            if (e instanceof ProviderLookup) {
                binder.getProvider(((ProviderLookup)e).getKey());
                continue;
            }
            if (e instanceof MembersInjectorLookup) {
                binder.getMembersInjector(((MembersInjectorLookup)e).getType());
                continue;
            }
            if (e instanceof PrivateElements) {
                PrivateElements privateElements = (PrivateElements)e;
                PrivateBinder privateBinder = binder.withSource(e.getSource()).newPrivateBinder();
                SpaceModule.replayRecordedElements(privateBinder, privateElements.getElements());
                for (Key<?> k : privateElements.getExposedKeys()) {
                    privateBinder.withSource(privateElements.getExposedSource(k)).expose(k);
                }
                continue;
            }
            e.applyTo(binder);
        }
    }

    private static final class RecordedElements {
        static final ConcurrentMap<String, List<Element>> cache = new ConcurrentHashMap<String, List<Element>>();

        private RecordedElements() {
        }
    }

    public static interface Strategy {
        public static final Strategy DEFAULT = new Strategy(){

            @Override
            public SpaceVisitor visitor(Binder binder) {
                return new QualifiedTypeVisitor(new QualifiedTypeBinder(binder));
            }
        };

        public SpaceVisitor visitor(Binder var1);
    }
}

