/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.jboss.shrinkwrap.resolver.impl.maven;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import shaded.org.jboss.shrinkwrap.resolver.api.maven.MavenResolvedArtifact;
import shaded.org.jboss.shrinkwrap.resolver.api.maven.PackagingType;
import shaded.org.jboss.shrinkwrap.resolver.api.maven.ScopeType;
import shaded.org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenDependencies;
import shaded.org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenDependency;
import shaded.org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenDependencyExclusion;
import shaded.org.jboss.shrinkwrap.resolver.api.maven.filter.MavenResolutionFilter;

class PostResolutionFilterApplicator {
    private static final Logger log = Logger.getLogger(PostResolutionFilterApplicator.class.getName());

    PostResolutionFilterApplicator() {
    }

    static Collection<MavenResolvedArtifact> postFilter(Collection<MavenResolvedArtifact> artifactResults) {
        RestrictPomArtifactFilter postResolutionFilter = RestrictPomArtifactFilter.INSTANCE;
        ArrayList<MavenResolvedArtifact> filteredArtifacts = new ArrayList<MavenResolvedArtifact>();
        List<MavenDependency> emptyList = Collections.emptyList();
        for (MavenResolvedArtifact artifact : artifactResults) {
            MavenDependency dependency = MavenDependencies.createDependency(artifact.getCoordinate(), ScopeType.COMPILE, false, new MavenDependencyExclusion[0]);
            if (!postResolutionFilter.accepts(dependency, emptyList, emptyList)) continue;
            filteredArtifacts.add(artifact);
        }
        return Collections.unmodifiableCollection(filteredArtifacts);
    }

    private static enum RestrictPomArtifactFilter implements MavenResolutionFilter
    {
        INSTANCE;


        @Override
        public boolean accepts(MavenDependency coordinate, List<MavenDependency> dependenciesForResolution, List<MavenDependency> dependencyAncestors) throws IllegalArgumentException {
            if (PackagingType.POM.equals(coordinate.getPackaging())) {
                if (log.isLoggable(Level.FINER)) {
                    log.finer("Filtering out POM dependency resolution: " + coordinate + "; its transitive dependencies will be included");
                }
                return false;
            }
            return true;
        }
    }
}

