/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.jboss.shrinkwrap.resolver.impl.maven.convert;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import shaded.org.apache.maven.model.Activation;
import shaded.org.apache.maven.model.ActivationFile;
import shaded.org.apache.maven.model.Profile;
import shaded.org.apache.maven.model.Repository;
import shaded.org.apache.maven.settings.ActivationOS;
import shaded.org.apache.maven.settings.ActivationProperty;
import shaded.org.apache.maven.settings.RepositoryPolicy;
import shaded.org.eclipse.aether.artifact.Artifact;
import shaded.org.eclipse.aether.artifact.ArtifactType;
import shaded.org.eclipse.aether.artifact.ArtifactTypeRegistry;
import shaded.org.eclipse.aether.artifact.DefaultArtifact;
import shaded.org.eclipse.aether.artifact.DefaultArtifactType;
import shaded.org.eclipse.aether.graph.Dependency;
import shaded.org.eclipse.aether.graph.Exclusion;
import shaded.org.eclipse.aether.repository.Authentication;
import shaded.org.eclipse.aether.repository.Proxy;
import shaded.org.eclipse.aether.repository.RemoteRepository;
import shaded.org.eclipse.aether.util.repository.AuthenticationBuilder;
import shaded.org.jboss.shrinkwrap.resolver.api.CoordinateParseException;
import shaded.org.jboss.shrinkwrap.resolver.api.maven.PackagingType;
import shaded.org.jboss.shrinkwrap.resolver.api.maven.ScopeType;
import shaded.org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenCoordinate;
import shaded.org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenCoordinates;
import shaded.org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenDependencies;
import shaded.org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenDependency;
import shaded.org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenDependencyExclusion;
import shaded.org.jboss.shrinkwrap.resolver.impl.maven.coordinate.MavenDependencyImpl;
import shaded.org.jboss.shrinkwrap.resolver.spi.MavenDependencySPI;

public class MavenConverter {
    private static final Logger log = Logger.getLogger(MavenConverter.class.getName());
    private static final String EMPTY = "";
    private static final MavenDependencyExclusion[] TYPESAFE_EXCLUSIONS_ARRAY = new MavenDependencyExclusion[0];

    private MavenConverter() {
        throw new UnsupportedOperationException("Utility class MavenConverter cannot be instantiated.");
    }

    public static MavenDependencyExclusion fromExclusion(shaded.org.apache.maven.model.Exclusion exclusion) {
        MavenDependencyExclusion translated = MavenDependencies.createExclusion(exclusion.getGroupId(), exclusion.getArtifactId());
        return translated;
    }

    public static MavenDependencyExclusion fromExclusion(Exclusion exclusion) {
        MavenDependencyExclusion translated = MavenDependencies.createExclusion(exclusion.getGroupId(), exclusion.getArtifactId());
        return translated;
    }

    public static Set<MavenDependencyExclusion> fromExclusions(Collection<Exclusion> exclusions) {
        LinkedHashSet<MavenDependencyExclusion> set = new LinkedHashSet<MavenDependencyExclusion>(exclusions.size());
        for (Exclusion e : exclusions) {
            set.add(MavenConverter.fromExclusion(e));
        }
        return set;
    }

    public static String toCanonicalForm(Artifact artifact) {
        StringBuilder sb = new StringBuilder();
        sb.append(artifact.getGroupId()).append(":");
        sb.append(artifact.getArtifactId()).append(":");
        PackagingType packaging = PackagingType.of(artifact.getProperty("type", artifact.getExtension()));
        String classifier = artifact.getClassifier().length() == 0 ? packaging.getClassifier() : artifact.getClassifier();
        sb.append(packaging.getId()).append(":");
        if (classifier.length() != 0) {
            sb.append(classifier).append(":");
        }
        sb.append(artifact.getVersion());
        return sb.toString();
    }

    public static MavenDependency fromDependency(Dependency dependency) {
        Artifact artifact = dependency.getArtifact();
        PackagingType packaging = PackagingType.of(artifact.getProperty("type", artifact.getExtension()));
        String classifier = artifact.getClassifier().length() == 0 ? packaging.getClassifier() : artifact.getClassifier();
        MavenCoordinate coordinate = MavenCoordinates.createCoordinate(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), packaging, classifier);
        ScopeType scope = ScopeType.RUNTIME;
        try {
            scope = ScopeType.fromScopeType(dependency.getScope());
        }
        catch (IllegalArgumentException e) {
            log.log(Level.WARNING, "Invalid scope {0} of dependency {1} will be replaced by <scope>runtime</scope>", new Object[]{dependency.getScope(), coordinate.toCanonicalForm()});
        }
        MavenDependency result = MavenDependencies.createDependency(coordinate, scope, dependency.isOptional(), MavenConverter.fromExclusions(dependency.getExclusions()).toArray(TYPESAFE_EXCLUSIONS_ARRAY));
        return result;
    }

    public static Set<MavenDependency> fromDependencies(Collection<Dependency> dependencies) {
        LinkedHashSet<MavenDependency> set = new LinkedHashSet<MavenDependency>();
        for (Dependency d : dependencies) {
            set.add(MavenConverter.fromDependency(d));
        }
        return set;
    }

    public static MavenDependency fromDependency(shaded.org.apache.maven.model.Dependency dependency, ArtifactTypeRegistry registry) {
        ArtifactType stereotype = registry.get(dependency.getType());
        if (stereotype == null) {
            stereotype = new DefaultArtifactType(dependency.getType());
        }
        boolean system = dependency.getSystemPath() != null && dependency.getSystemPath().length() > 0;
        Map<String, String> props = null;
        if (system) {
            props = Collections.singletonMap("localPath", dependency.getSystemPath());
        }
        DefaultArtifact artifact = new DefaultArtifact(dependency.getGroupId(), dependency.getArtifactId(), dependency.getClassifier(), null, dependency.getVersion(), props, stereotype);
        LinkedHashSet<MavenDependencyExclusion> exclusions = new LinkedHashSet<MavenDependencyExclusion>();
        for (shaded.org.apache.maven.model.Exclusion e : dependency.getExclusions()) {
            exclusions.add(MavenConverter.fromExclusion(e));
        }
        PackagingType packaging = PackagingType.of(artifact.getProperty("type", artifact.getExtension()));
        String classifier = artifact.getClassifier().length() == 0 ? packaging.getClassifier() : artifact.getClassifier();
        MavenCoordinate coordinate = MavenCoordinates.createCoordinate(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), packaging, classifier);
        String resolvedScope = dependency.getScope();
        boolean undeclaredScope = resolvedScope == null;
        ScopeType scope = ScopeType.RUNTIME;
        try {
            scope = ScopeType.fromScopeType(resolvedScope);
        }
        catch (IllegalArgumentException e) {
            log.log(Level.WARNING, "Invalid scope {0} of dependency {1} will be replaced by <scope>runtime</scope>", new Object[]{dependency.getScope(), coordinate.toCanonicalForm()});
        }
        MavenDependencyImpl result = new MavenDependencyImpl(coordinate, scope, dependency.isOptional(), undeclaredScope, exclusions.toArray(TYPESAFE_EXCLUSIONS_ARRAY));
        return result;
    }

    public static Set<MavenDependency> fromDependencies(Collection<shaded.org.apache.maven.model.Dependency> dependencies, ArtifactTypeRegistry registry) {
        LinkedHashSet<MavenDependency> set = new LinkedHashSet<MavenDependency>();
        for (shaded.org.apache.maven.model.Dependency d : dependencies) {
            set.add(MavenConverter.fromDependency(d, registry));
        }
        return set;
    }

    public static Dependency asDependency(MavenDependencySPI dependency, ArtifactTypeRegistry registry) {
        String scope = dependency.getScope().toString();
        if (dependency.isUndeclaredScope()) {
            scope = EMPTY;
        }
        return new Dependency(MavenConverter.asArtifact(dependency, registry), scope, dependency.isOptional(), MavenConverter.asExclusions(dependency.getExclusions()));
    }

    public static List<Dependency> asDependencies(List<MavenDependency> dependencies, ArtifactTypeRegistry registry) {
        ArrayList<Dependency> list = new ArrayList<Dependency>(dependencies.size());
        for (MavenDependency d : dependencies) {
            list.add(MavenConverter.asDependency((MavenDependencySPI)d, registry));
        }
        return list;
    }

    public static Artifact asArtifact(MavenCoordinate coordinate, ArtifactTypeRegistry registry) throws CoordinateParseException {
        try {
            return new DefaultArtifact(coordinate.getGroupId(), coordinate.getArtifactId(), coordinate.getClassifier(), coordinate.getPackaging().getExtension(), coordinate.getVersion(), registry.get(coordinate.getPackaging().getId()));
        }
        catch (IllegalArgumentException e) {
            throw new CoordinateParseException("Unable to create artifact from invalid coordinates " + coordinate.toCanonicalForm());
        }
    }

    public static Exclusion asExclusion(MavenDependencyExclusion coordinates) {
        String group = coordinates.getGroupId();
        String artifact = coordinates.getArtifactId();
        group = group == null || group.length() == 0 ? "*" : group;
        artifact = artifact == null || artifact.length() == 0 ? "*" : artifact;
        return new Exclusion(group, artifact, "*", "*");
    }

    public static List<Exclusion> asExclusions(Collection<MavenDependencyExclusion> exclusions) {
        ArrayList<Exclusion> list = new ArrayList<Exclusion>(exclusions.size());
        for (MavenDependencyExclusion coords : exclusions) {
            list.add(MavenConverter.asExclusion(coords));
        }
        return list;
    }

    public static RemoteRepository asRemoteRepository(Repository repository) {
        return new RemoteRepository.Builder(repository.getId(), repository.getLayout(), repository.getUrl()).setSnapshotPolicy(MavenConverter.asRepositoryPolicy(repository.getSnapshots())).setReleasePolicy(MavenConverter.asRepositoryPolicy(repository.getReleases())).build();
    }

    public static RemoteRepository asRemoteRepository(shaded.org.apache.maven.settings.Repository repository) {
        return new RemoteRepository.Builder(repository.getId(), repository.getLayout(), repository.getUrl()).setSnapshotPolicy(MavenConverter.asRepositoryPolicy(repository.getSnapshots())).setReleasePolicy(MavenConverter.asRepositoryPolicy(repository.getReleases())).build();
    }

    public static Proxy asProxy(shaded.org.apache.maven.settings.Proxy proxy) {
        Authentication authentication = proxy.getUsername() != null || proxy.getPassword() != null ? new AuthenticationBuilder().addUsername(proxy.getUsername()).addPassword(proxy.getPassword()).build() : null;
        return new Proxy(proxy.getProtocol(), proxy.getHost(), proxy.getPort(), authentication);
    }

    public static Profile asProfile(shaded.org.apache.maven.settings.Profile profile) {
        Profile mavenProfile = new Profile();
        if (profile != null) {
            mavenProfile.setId(profile.getId());
            mavenProfile.setActivation(MavenConverter.asActivation(profile.getActivation()));
            mavenProfile.setProperties(profile.getProperties());
            mavenProfile.setRepositories(MavenConverter.asRepositories(profile.getRepositories()));
            mavenProfile.setPluginRepositories(MavenConverter.asRepositories(profile.getPluginRepositories()));
        }
        return mavenProfile;
    }

    public static List<Profile> asProfiles(List<shaded.org.apache.maven.settings.Profile> profiles) {
        ArrayList<Profile> mavenProfiles = new ArrayList<Profile>();
        for (shaded.org.apache.maven.settings.Profile p : profiles) {
            mavenProfiles.add(MavenConverter.asProfile(p));
        }
        return mavenProfiles;
    }

    private static Repository asRepository(shaded.org.apache.maven.settings.Repository repository) {
        Repository mavenRepository = new Repository();
        if (repository != null) {
            mavenRepository.setId(repository.getId());
            mavenRepository.setLayout(repository.getLayout());
            mavenRepository.setName(repository.getName());
            mavenRepository.setUrl(repository.getUrl());
            mavenRepository.setReleases(MavenConverter.asMavenRepositoryPolicy(repository.getReleases()));
            mavenRepository.setSnapshots(MavenConverter.asMavenRepositoryPolicy(repository.getSnapshots()));
        }
        return mavenRepository;
    }

    private static List<Repository> asRepositories(List<shaded.org.apache.maven.settings.Repository> repositories) {
        ArrayList<Repository> mavenRepositories = new ArrayList<Repository>();
        for (shaded.org.apache.maven.settings.Repository repository : repositories) {
            mavenRepositories.add(MavenConverter.asRepository(repository));
        }
        return mavenRepositories;
    }

    private static Activation asActivation(shaded.org.apache.maven.settings.Activation activation) {
        Activation mavenActivation = new Activation();
        if (activation != null) {
            mavenActivation.setActiveByDefault(activation.isActiveByDefault());
            mavenActivation.setJdk(activation.getJdk());
            if (activation.getFile() != null) {
                mavenActivation.setFile(MavenConverter.asActivationFile(activation.getFile()));
            }
            if (activation.getOs() != null) {
                mavenActivation.setOs(MavenConverter.asActivationOS(activation.getOs()));
            }
            if (activation.getProperty() != null) {
                mavenActivation.setProperty(MavenConverter.asActivationProperty(activation.getProperty()));
            }
        }
        return mavenActivation;
    }

    private static ActivationFile asActivationFile(shaded.org.apache.maven.settings.ActivationFile file) {
        ActivationFile mavenActivationFile = new ActivationFile();
        if (file != null) {
            mavenActivationFile.setExists(file.getExists());
            mavenActivationFile.setMissing(file.getMissing());
        }
        return mavenActivationFile;
    }

    private static shaded.org.apache.maven.model.ActivationOS asActivationOS(ActivationOS os) {
        shaded.org.apache.maven.model.ActivationOS mavenOS = new shaded.org.apache.maven.model.ActivationOS();
        if (os != null) {
            mavenOS.setArch(os.getArch());
            mavenOS.setFamily(os.getFamily());
            mavenOS.setName(os.getName());
            mavenOS.setVersion(os.getVersion());
        }
        return mavenOS;
    }

    private static shaded.org.apache.maven.model.ActivationProperty asActivationProperty(ActivationProperty property) {
        shaded.org.apache.maven.model.ActivationProperty mavenProperty = new shaded.org.apache.maven.model.ActivationProperty();
        if (property != null) {
            mavenProperty.setName(property.getName());
            mavenProperty.setValue(property.getValue());
        }
        return mavenProperty;
    }

    private static shaded.org.eclipse.aether.repository.RepositoryPolicy asRepositoryPolicy(shaded.org.apache.maven.model.RepositoryPolicy policy) {
        boolean enabled = true;
        String checksums = "warn";
        String updates = "daily";
        if (policy != null) {
            enabled = policy.isEnabled();
            if (policy.getUpdatePolicy() != null) {
                updates = policy.getUpdatePolicy();
            }
            if (policy.getChecksumPolicy() != null) {
                checksums = policy.getChecksumPolicy();
            }
        }
        return new shaded.org.eclipse.aether.repository.RepositoryPolicy(enabled, updates, checksums);
    }

    private static shaded.org.eclipse.aether.repository.RepositoryPolicy asRepositoryPolicy(RepositoryPolicy policy) {
        boolean enabled = true;
        String checksums = "warn";
        String updates = "daily";
        if (policy != null) {
            enabled = policy.isEnabled();
            if (policy.getUpdatePolicy() != null) {
                updates = policy.getUpdatePolicy();
            }
            if (policy.getChecksumPolicy() != null) {
                checksums = policy.getChecksumPolicy();
            }
        }
        return new shaded.org.eclipse.aether.repository.RepositoryPolicy(enabled, updates, checksums);
    }

    private static shaded.org.apache.maven.model.RepositoryPolicy asMavenRepositoryPolicy(RepositoryPolicy policy) {
        shaded.org.apache.maven.model.RepositoryPolicy mavenPolicy = new shaded.org.apache.maven.model.RepositoryPolicy();
        if (policy != null) {
            mavenPolicy.setChecksumPolicy(policy.getChecksumPolicy());
            mavenPolicy.setUpdatePolicy(policy.getUpdatePolicy());
            mavenPolicy.setEnabled(policy.isEnabled());
        }
        return mavenPolicy;
    }
}

