/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.jboss.shrinkwrap.resolver.impl.maven.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import shaded.org.apache.maven.model.Dependency;
import shaded.org.apache.maven.model.Parent;
import shaded.org.apache.maven.model.Repository;
import shaded.org.apache.maven.model.building.FileModelSource;
import shaded.org.apache.maven.model.building.ModelSource;
import shaded.org.apache.maven.model.resolution.InvalidRepositoryException;
import shaded.org.apache.maven.model.resolution.ModelResolver;
import shaded.org.apache.maven.model.resolution.UnresolvableModelException;
import shaded.org.eclipse.aether.RepositorySystemSession;
import shaded.org.eclipse.aether.artifact.Artifact;
import shaded.org.eclipse.aether.artifact.DefaultArtifact;
import shaded.org.eclipse.aether.repository.RemoteRepository;
import shaded.org.eclipse.aether.resolution.ArtifactRequest;
import shaded.org.eclipse.aether.resolution.ArtifactResolutionException;
import shaded.org.eclipse.aether.resolution.VersionRangeRequest;
import shaded.org.eclipse.aether.resolution.VersionRangeResolutionException;
import shaded.org.eclipse.aether.resolution.VersionRangeResult;
import shaded.org.jboss.shrinkwrap.resolver.impl.maven.bootstrap.MavenRepositorySystem;
import shaded.org.jboss.shrinkwrap.resolver.impl.maven.convert.MavenConverter;

public class MavenModelResolver
implements ModelResolver {
    private final List<RemoteRepository> repositories;
    private final Set<String> repositoryIds;
    private final MavenRepositorySystem system;
    private final RepositorySystemSession session;

    public MavenModelResolver(MavenRepositorySystem system, RepositorySystemSession session, List<RemoteRepository> remoteRepositories) {
        this.system = system;
        this.session = session;
        this.repositories = new ArrayList<RemoteRepository>(remoteRepositories.size());
        for (RemoteRepository remoteRepository : remoteRepositories) {
            this.repositories.add(new RemoteRepository.Builder(remoteRepository).build());
        }
        this.repositoryIds = new HashSet<String>(this.repositories.size());
        for (RemoteRepository repository : this.repositories) {
            this.repositoryIds.add(repository.getId());
        }
    }

    private MavenModelResolver(MavenModelResolver origin) {
        this(origin.system, origin.session, origin.repositories);
    }

    @Override
    public void addRepository(Repository repository) throws InvalidRepositoryException {
        this.addRepository(repository, false);
    }

    @Override
    public ModelResolver newCopy() {
        return new MavenModelResolver(this);
    }

    @Override
    public ModelSource resolveModel(String groupId, String artifactId, String version) throws UnresolvableModelException {
        Artifact pomArtifact = new DefaultArtifact(groupId, artifactId, "", "pom", version);
        try {
            ArtifactRequest request = new ArtifactRequest(pomArtifact, this.repositories, null);
            pomArtifact = this.system.resolveArtifact(this.session, request).getArtifact();
        }
        catch (ArtifactResolutionException e) {
            throw new UnresolvableModelException("Failed to resolve POM for " + groupId + ":" + artifactId + ":" + version + " due to " + e.getMessage(), groupId, artifactId, version, e);
        }
        File pomFile = pomArtifact.getFile();
        return new FileModelSource(pomFile);
    }

    @Override
    public ModelSource resolveModel(Parent parent) throws UnresolvableModelException {
        DefaultArtifact artifact = new DefaultArtifact(parent.getGroupId(), parent.getArtifactId(), "", "pom", parent.getVersion());
        VersionRangeRequest versionRangeRequest = new VersionRangeRequest(artifact, this.repositories, null);
        try {
            VersionRangeResult versionRangeResult = this.system.resolveVersionRange(this.session, versionRangeRequest);
            if (versionRangeResult.getHighestVersion() == null) {
                throw new UnresolvableModelException(String.format("No versions matched the requested parent version range '%s'", parent.getVersion()), parent.getGroupId(), parent.getArtifactId(), parent.getVersion());
            }
            if (versionRangeResult.getVersionConstraint() != null && versionRangeResult.getVersionConstraint().getRange() != null && versionRangeResult.getVersionConstraint().getRange().getUpperBound() == null) {
                throw new UnresolvableModelException(String.format("The requested parent version range '%s' does not specify an upper bound", parent.getVersion()), parent.getGroupId(), parent.getArtifactId(), parent.getVersion());
            }
            parent.setVersion(versionRangeResult.getHighestVersion().toString());
        }
        catch (VersionRangeResolutionException e) {
            throw new UnresolvableModelException(e.getMessage(), parent.getGroupId(), parent.getArtifactId(), parent.getVersion(), e);
        }
        return this.resolveModel(parent.getGroupId(), parent.getArtifactId(), parent.getVersion());
    }

    @Override
    public ModelSource resolveModel(Dependency dependency) throws UnresolvableModelException {
        try {
            DefaultArtifact artifact = new DefaultArtifact(dependency.getGroupId(), dependency.getArtifactId(), "", "pom", dependency.getVersion());
            VersionRangeRequest versionRangeRequest = new VersionRangeRequest(artifact, this.repositories, null);
            VersionRangeResult versionRangeResult = this.system.resolveVersionRange(this.session, versionRangeRequest);
            if (versionRangeResult.getHighestVersion() == null) {
                throw new UnresolvableModelException(String.format("No versions matched the requested dependency version range '%s'", dependency.getVersion()), dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion());
            }
            if (versionRangeResult.getVersionConstraint() != null && versionRangeResult.getVersionConstraint().getRange() != null && versionRangeResult.getVersionConstraint().getRange().getUpperBound() == null) {
                throw new UnresolvableModelException(String.format("The requested dependency version range '%s' does not specify an upper bound", dependency.getVersion()), dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion());
            }
            dependency.setVersion(versionRangeResult.getHighestVersion().toString());
            return this.resolveModel(dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion());
        }
        catch (VersionRangeResolutionException e) {
            throw new UnresolvableModelException(e.getMessage(), dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion(), e);
        }
    }

    @Override
    public void addRepository(Repository repository, boolean replace) throws InvalidRepositoryException {
        if (this.session.isIgnoreArtifactDescriptorRepositories()) {
            return;
        }
        if (!this.repositoryIds.add(repository.getId())) {
            if (!replace) {
                return;
            }
            MavenModelResolver.removeMatchingRepository(this.repositories, repository.getId());
        }
        this.repositories.add(MavenConverter.asRemoteRepository(repository));
    }

    private static void removeMatchingRepository(List<RemoteRepository> repositories, String id) {
        ArrayList<RemoteRepository> matchingRepositoriesToRemove = new ArrayList<RemoteRepository>();
        for (RemoteRepository remoteRepository : repositories) {
            if (!remoteRepository.getId().equals(id)) continue;
            matchingRepositoriesToRemove.add(remoteRepository);
        }
        repositories.removeAll(matchingRepositoriesToRemove);
    }
}

