/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.eclipse.aether.named.support;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import shaded.org.eclipse.aether.named.support.LockUpgradeNotSupportedException;
import shaded.org.eclipse.aether.named.support.NamedLockFactorySupport;
import shaded.org.eclipse.aether.named.support.NamedLockSupport;
import shaded.org.eclipse.aether.named.support.Retry;

public final class FileLockNamedLock
extends NamedLockSupport {
    private static final long RETRY_SLEEP_MILLIS = 100L;
    private static final long LOCK_POSITION = 0L;
    private static final long LOCK_SIZE = 1L;
    private final Map<Thread, Deque<Boolean>> threadSteps = new HashMap<Thread, Deque<Boolean>>();
    private final FileChannel fileChannel;
    private final AtomicReference<FileLock> fileLockRef;
    private final ReentrantLock criticalRegion;

    public FileLockNamedLock(String name, FileChannel fileChannel, NamedLockFactorySupport factory) {
        super(name, factory);
        this.fileChannel = fileChannel;
        this.fileLockRef = new AtomicReference<Object>(null);
        this.criticalRegion = new ReentrantLock();
    }

    @Override
    protected boolean doLockShared(long time, TimeUnit unit) throws InterruptedException {
        return Retry.retry(time, unit, 100L, this::doLockShared, null, false);
    }

    @Override
    protected boolean doLockExclusively(long time, TimeUnit unit) throws InterruptedException {
        return Retry.retry(time, unit, 100L, this::doLockExclusively, null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Boolean doLockShared() {
        if (this.criticalRegion.tryLock()) {
            try {
                Deque steps = this.threadSteps.computeIfAbsent(Thread.currentThread(), k -> new ArrayDeque());
                FileLock obtainedLock = this.fileLockRef.get();
                if (obtainedLock != null) {
                    if (obtainedLock.isShared()) {
                        steps.push(Boolean.TRUE);
                        Boolean bl = true;
                        return bl;
                    }
                    boolean weOwnExclusive = steps.contains(Boolean.FALSE);
                    if (weOwnExclusive) {
                        steps.push(Boolean.TRUE);
                        Boolean bl = true;
                        return bl;
                    }
                    Boolean bl = null;
                    return bl;
                }
                FileLock fileLock = this.obtainFileLock(true);
                if (fileLock != null) {
                    this.fileLockRef.set(fileLock);
                    steps.push(Boolean.TRUE);
                    Boolean bl = true;
                    return bl;
                }
            }
            finally {
                this.criticalRegion.unlock();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Boolean doLockExclusively() {
        if (this.criticalRegion.tryLock()) {
            try {
                Deque steps = this.threadSteps.computeIfAbsent(Thread.currentThread(), k -> new ArrayDeque());
                FileLock obtainedLock = this.fileLockRef.get();
                if (obtainedLock != null) {
                    if (obtainedLock.isShared()) {
                        boolean weOwnShared = steps.contains(Boolean.TRUE);
                        if (weOwnShared) {
                            throw new LockUpgradeNotSupportedException(this);
                        }
                        Boolean bl = null;
                        return bl;
                    }
                    boolean weOwnExclusive = steps.contains(Boolean.FALSE);
                    if (weOwnExclusive) {
                        steps.push(Boolean.FALSE);
                        Boolean bl = true;
                        return bl;
                    }
                    Boolean bl = null;
                    return bl;
                }
                FileLock fileLock = this.obtainFileLock(false);
                if (fileLock != null) {
                    this.fileLockRef.set(fileLock);
                    steps.push(Boolean.FALSE);
                    Boolean bl = true;
                    return bl;
                }
            }
            finally {
                this.criticalRegion.unlock();
            }
        }
        return null;
    }

    @Override
    protected void doUnlock() {
        block6: {
            this.criticalRegion.lock();
            try {
                Deque steps = this.threadSteps.computeIfAbsent(Thread.currentThread(), k -> new ArrayDeque());
                if (steps.isEmpty()) {
                    throw new IllegalStateException("Wrong API usage: unlock without lock");
                }
                steps.pop();
                if (!steps.isEmpty() || this.anyOtherThreadHasSteps()) break block6;
                try {
                    ((FileLock)this.fileLockRef.getAndSet(null)).release();
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            finally {
                this.criticalRegion.unlock();
            }
        }
    }

    private boolean anyOtherThreadHasSteps() {
        return this.threadSteps.entrySet().stream().filter(e -> !Thread.currentThread().equals(e.getKey())).map(Map.Entry::getValue).anyMatch(d -> !d.isEmpty());
    }

    private FileLock obtainFileLock(boolean shared) {
        FileLock result;
        try {
            result = this.fileChannel.tryLock(0L, 1L, shared);
        }
        catch (OverlappingFileLockException e) {
            this.logger.trace("File lock overlap on '{}'", (Object)this.name(), (Object)e);
            return null;
        }
        catch (IOException e) {
            this.logger.trace("Failure on acquire of file lock for '{}'", (Object)this.name(), (Object)e);
            throw new UncheckedIOException("Failed to acquire lock file channel for '" + this.name() + "'", e);
        }
        return result;
    }
}

