/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.jboss.shrinkwrap.resolver.api.maven.strategy;

import java.util.ArrayList;
import shaded.org.jboss.shrinkwrap.resolver.api.maven.filter.MavenResolutionFilter;
import shaded.org.jboss.shrinkwrap.resolver.api.maven.strategy.DefaultTransitiveExclusionPolicy;
import shaded.org.jboss.shrinkwrap.resolver.api.maven.strategy.MavenResolutionStrategy;
import shaded.org.jboss.shrinkwrap.resolver.api.maven.strategy.TransitiveExclusionPolicy;

public class CombinedStrategy
implements MavenResolutionStrategy {
    private static final MavenResolutionFilter[][] EMPTY_CHAIN_ARRAY = new MavenResolutionFilter[0][];
    private static final MavenResolutionFilter[] EMPTY_FILTER_ARRAY = new MavenResolutionFilter[0];
    private final MavenResolutionFilter[] resolutionFilters;

    public CombinedStrategy(MavenResolutionStrategy ... strategies) {
        if (strategies.length == 0) {
            throw new IllegalArgumentException("There must be at least one strategy for a combined strategy.");
        }
        ArrayList<MavenResolutionFilter[]> resolutionFilterChains = new ArrayList<MavenResolutionFilter[]>();
        for (MavenResolutionStrategy strategy : strategies) {
            resolutionFilterChains.add(strategy.getResolutionFilters());
        }
        this.resolutionFilters = this.combine((MavenResolutionFilter[][])resolutionFilterChains.toArray((T[])EMPTY_CHAIN_ARRAY));
    }

    @Override
    public MavenResolutionFilter[] getResolutionFilters() {
        return this.resolutionFilters;
    }

    private MavenResolutionFilter[] combine(MavenResolutionFilter[] ... inputFilterChains) {
        ArrayList<MavenResolutionFilter> combinedFilters = new ArrayList<MavenResolutionFilter>();
        for (MavenResolutionFilter[] filterChain : inputFilterChains) {
            for (int i = 0; i < filterChain.length; ++i) {
                combinedFilters.add(filterChain[i]);
            }
        }
        return combinedFilters.toArray(EMPTY_FILTER_ARRAY);
    }

    @Override
    public TransitiveExclusionPolicy getTransitiveExclusionPolicy() {
        return DefaultTransitiveExclusionPolicy.INSTANCE;
    }
}

