/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.maven.repository.internal;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import shaded.com.google.inject.AbstractModule;
import shaded.com.google.inject.Provides;
import shaded.com.google.inject.name.Names;
import shaded.javax.inject.Named;
import shaded.javax.inject.Singleton;
import shaded.org.apache.maven.model.building.DefaultModelBuilderFactory;
import shaded.org.apache.maven.model.building.ModelBuilder;
import shaded.org.apache.maven.repository.internal.DefaultArtifactDescriptorReader;
import shaded.org.apache.maven.repository.internal.DefaultModelCacheFactory;
import shaded.org.apache.maven.repository.internal.DefaultVersionRangeResolver;
import shaded.org.apache.maven.repository.internal.DefaultVersionResolver;
import shaded.org.apache.maven.repository.internal.ModelCacheFactory;
import shaded.org.apache.maven.repository.internal.SnapshotMetadataGeneratorFactory;
import shaded.org.apache.maven.repository.internal.VersionsMetadataGeneratorFactory;
import shaded.org.eclipse.aether.impl.ArtifactDescriptorReader;
import shaded.org.eclipse.aether.impl.MetadataGeneratorFactory;
import shaded.org.eclipse.aether.impl.VersionRangeResolver;
import shaded.org.eclipse.aether.impl.VersionResolver;
import shaded.org.eclipse.aether.impl.guice.AetherModule;

public final class MavenResolverModule
extends AbstractModule {
    @Override
    protected void configure() {
        this.install(new AetherModule());
        this.bind(ArtifactDescriptorReader.class).to(DefaultArtifactDescriptorReader.class).in(Singleton.class);
        this.bind(VersionResolver.class).to(DefaultVersionResolver.class).in(Singleton.class);
        this.bind(VersionRangeResolver.class).to(DefaultVersionRangeResolver.class).in(Singleton.class);
        this.bind(MetadataGeneratorFactory.class).annotatedWith(Names.named("snapshot")).to(SnapshotMetadataGeneratorFactory.class).in(Singleton.class);
        this.bind(MetadataGeneratorFactory.class).annotatedWith(Names.named("versions")).to(VersionsMetadataGeneratorFactory.class).in(Singleton.class);
        this.bind(ModelBuilder.class).toInstance(new DefaultModelBuilderFactory().newInstance());
        this.bind(ModelCacheFactory.class).to(DefaultModelCacheFactory.class).in(Singleton.class);
    }

    @Provides
    @Singleton
    Set<MetadataGeneratorFactory> provideMetadataGeneratorFactories(@Named(value="snapshot") MetadataGeneratorFactory snapshot, @Named(value="versions") MetadataGeneratorFactory versions) {
        HashSet<MetadataGeneratorFactory> factories = new HashSet<MetadataGeneratorFactory>(2);
        factories.add(snapshot);
        factories.add(versions);
        return Collections.unmodifiableSet(factories);
    }
}

