/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.codehaus.plexus;

import java.io.File;
import java.io.InputStream;
import java.util.Map;
import junit.framework.TestCase;
import shaded.org.codehaus.plexus.ContainerConfiguration;
import shaded.org.codehaus.plexus.DefaultContainerConfiguration;
import shaded.org.codehaus.plexus.DefaultPlexusContainer;
import shaded.org.codehaus.plexus.PlexusContainer;
import shaded.org.codehaus.plexus.PlexusContainerException;
import shaded.org.codehaus.plexus.component.repository.exception.ComponentLifecycleException;
import shaded.org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import shaded.org.codehaus.plexus.context.Context;
import shaded.org.codehaus.plexus.context.DefaultContext;

public abstract class PlexusTestCase
extends TestCase {
    private static final String PLEXUS_HOME = "plexus.home";
    private volatile PlexusContainer container;

    public static String getBasedir() {
        return Lazy.BASEDIR;
    }

    public static File getTestFile(String path) {
        return PlexusTestCase.getTestFile(PlexusTestCase.getBasedir(), path);
    }

    public static File getTestFile(String basedir, String path) {
        File root = new File(basedir);
        if (!root.isAbsolute()) {
            root = new File(PlexusTestCase.getBasedir(), basedir);
        }
        return new File(root, path);
    }

    public static String getTestPath(String path) {
        return PlexusTestCase.getTestFile(path).getAbsolutePath();
    }

    public static String getTestPath(String basedir, String path) {
        return PlexusTestCase.getTestFile(basedir, path).getAbsolutePath();
    }

    public static String getTestConfiguration(Class<?> clazz) {
        String name = clazz.getName();
        int i = name.indexOf(36);
        return String.valueOf((i < 0 ? name : name.substring(0, i)).replace('.', '/')) + ".xml";
    }

    public final String getTestConfiguration() {
        return PlexusTestCase.getTestConfiguration(((Object)((Object)this)).getClass());
    }

    protected void customizeContext(Context context) {
    }

    protected String getCustomConfigurationName() {
        return null;
    }

    protected void customizeContainerConfiguration(ContainerConfiguration configuration) {
    }

    protected void setUp() throws Exception {
    }

    protected PlexusContainer getContainer() {
        if (this.container == null) {
            this.setupContainer();
        }
        return this.container;
    }

    protected synchronized void setupContainer() {
        if (this.container == null) {
            try {
                this.container = new DefaultPlexusContainer(this.config());
            }
            catch (PlexusContainerException e) {
                throw new IllegalArgumentException(e);
            }
        }
    }

    protected synchronized void teardownContainer() {
        if (this.container != null) {
            this.container.dispose();
            this.container = null;
        }
    }

    protected void tearDown() throws Exception {
        if (this.container != null) {
            this.teardownContainer();
        }
    }

    protected final String getConfigurationName(String name) {
        return this.getTestConfiguration();
    }

    protected final ClassLoader getClassLoader() {
        return ((Object)((Object)this)).getClass().getClassLoader();
    }

    protected final InputStream getResourceAsStream(String name) {
        return ((Object)((Object)this)).getClass().getResourceAsStream(name);
    }

    protected final Object lookup(String role) throws ComponentLookupException {
        return this.getContainer().lookup(role);
    }

    protected final Object lookup(String role, String hint) throws ComponentLookupException {
        return this.getContainer().lookup(role, hint);
    }

    protected final <T> T lookup(Class<T> role) throws ComponentLookupException {
        return this.getContainer().lookup(role);
    }

    protected final <T> T lookup(Class<T> role, String hint) throws ComponentLookupException {
        return this.getContainer().lookup(role, hint);
    }

    protected final void release(Object component) throws ComponentLifecycleException {
        this.getContainer().release(component);
    }

    private final ContainerConfiguration config() {
        DefaultContainerConfiguration config = new DefaultContainerConfiguration();
        config.setName("test").setContext(this.context());
        String path = this.getCustomConfigurationName();
        if (path == null) {
            path = this.getConfigurationName(null);
        }
        config.setContainerConfiguration(path);
        this.customizeContainerConfiguration(config);
        return config;
    }

    private final Map<Object, Object> context() {
        DefaultContext context = new DefaultContext();
        context.put("basedir", PlexusTestCase.getBasedir());
        this.customizeContext(context);
        if (!context.contains(PLEXUS_HOME)) {
            context.put(PLEXUS_HOME, PlexusTestCase.plexusHome());
        }
        return context.getContextData();
    }

    private static String plexusHome() {
        File home = PlexusTestCase.getTestFile("target/plexus-home");
        if (!home.isDirectory()) {
            home.mkdirs();
        }
        return home.getAbsolutePath();
    }

    private static final class Lazy {
        static final String BASEDIR;

        static {
            String path = System.getProperty("basedir");
            BASEDIR = path != null ? path : new File("").getAbsolutePath();
        }

        private Lazy() {
        }
    }
}

