/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.eclipse.aether.internal.impl.synccontext.named;

import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;
import shaded.org.eclipse.aether.RepositorySystemSession;
import shaded.org.eclipse.aether.artifact.Artifact;
import shaded.org.eclipse.aether.internal.impl.synccontext.named.NameMapper;
import shaded.org.eclipse.aether.metadata.Metadata;
import shaded.org.eclipse.aether.util.ConfigUtils;
import shaded.org.eclipse.aether.util.StringDigestUtil;
import shaded.org.slf4j.Logger;
import shaded.org.slf4j.LoggerFactory;

public class DiscriminatingNameMapper
implements NameMapper {
    private static final String CONFIG_PROP_DISCRIMINATOR = "aether.syncContext.named.discriminating.discriminator";
    private static final String CONFIG_PROP_HOSTNAME = "aether.syncContext.named.discriminating.hostname";
    private static final String DEFAULT_DISCRIMINATOR_DIGEST = "da39a3ee5e6b4b0d3255bfef95601890afd80709";
    private static final String DEFAULT_HOSTNAME = "localhost";
    private static final Logger LOGGER = LoggerFactory.getLogger(DiscriminatingNameMapper.class);
    private final NameMapper delegate;
    private final String hostname;

    public DiscriminatingNameMapper(NameMapper delegate) {
        this.delegate = Objects.requireNonNull(delegate);
        this.hostname = this.getHostname();
    }

    @Override
    public boolean isFileSystemFriendly() {
        return false;
    }

    @Override
    public Collection<String> nameLocks(RepositorySystemSession session, Collection<? extends Artifact> artifacts, Collection<? extends Metadata> metadatas) {
        String discriminator = this.createDiscriminator(session);
        return this.delegate.nameLocks(session, artifacts, metadatas).stream().map(s -> discriminator + ":" + s).collect(Collectors.toList());
    }

    private String getHostname() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            LOGGER.warn("Failed to get hostname, using '{}'", (Object)DEFAULT_HOSTNAME, (Object)e);
            return DEFAULT_HOSTNAME;
        }
    }

    private String createDiscriminator(RepositorySystemSession session) {
        String discriminator = ConfigUtils.getString(session, null, CONFIG_PROP_DISCRIMINATOR);
        if (discriminator == null || discriminator.isEmpty()) {
            String hostname = ConfigUtils.getString(session, this.hostname, CONFIG_PROP_HOSTNAME);
            File basedir = session.getLocalRepository().getBasedir();
            discriminator = hostname + ":" + basedir;
            try {
                return StringDigestUtil.sha1(discriminator);
            }
            catch (Exception e) {
                LOGGER.warn("Failed to calculate discriminator digest, using '{}'", (Object)DEFAULT_DISCRIMINATOR_DIGEST, (Object)e);
                return DEFAULT_DISCRIMINATOR_DIGEST;
            }
        }
        return discriminator;
    }
}

