/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.jboss.shrinkwrap.resolver.impl.maven.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import shaded.org.jboss.shrinkwrap.resolver.impl.maven.util.Validate;

public class SettingsXmlProfileSelector {
    private SettingsXmlProfileSelector() {
    }

    public static List<String> explicitlyActivatedProfiles(String ... profiles) {
        if (profiles.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<String> activated = new ArrayList<String>();
        for (String profileId : profiles) {
            Validate.notNullOrEmpty(profileId, "Invalid name (\"" + profileId + "\") of a profile to be activated");
            if (profileId.startsWith("-") || profileId.startsWith("!")) continue;
            activated.add(profileId);
        }
        return activated;
    }

    public static List<String> explicitlyDisabledProfiles(String ... profiles) {
        if (profiles.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<String> disabled = new ArrayList<String>();
        for (String profileId : profiles) {
            if (profileId == null || !profileId.startsWith("-") && !profileId.startsWith("!")) continue;
            String disabledId = profileId.substring(1);
            Validate.notNullOrEmpty(disabledId, "Invalid name (\"" + profileId + "\") of a profile do be disabled");
            disabled.add(disabledId);
        }
        return disabled;
    }
}

