/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.jboss.shrinkwrap.resolver.impl.maven.bootstrap;

import java.io.File;
import shaded.org.apache.maven.settings.Mirror;
import shaded.org.apache.maven.settings.Proxy;
import shaded.org.apache.maven.settings.Settings;
import shaded.org.eclipse.aether.RepositoryListener;
import shaded.org.eclipse.aether.RepositorySystem;
import shaded.org.eclipse.aether.RepositorySystemSession;
import shaded.org.eclipse.aether.artifact.ArtifactTypeRegistry;
import shaded.org.eclipse.aether.artifact.DefaultArtifactType;
import shaded.org.eclipse.aether.collection.DependencyGraphTransformer;
import shaded.org.eclipse.aether.collection.DependencyManager;
import shaded.org.eclipse.aether.collection.DependencyTraverser;
import shaded.org.eclipse.aether.repository.LocalRepository;
import shaded.org.eclipse.aether.repository.LocalRepositoryManager;
import shaded.org.eclipse.aether.repository.MirrorSelector;
import shaded.org.eclipse.aether.repository.ProxySelector;
import shaded.org.eclipse.aether.repository.WorkspaceReader;
import shaded.org.eclipse.aether.resolution.ArtifactDescriptorPolicy;
import shaded.org.eclipse.aether.transfer.TransferListener;
import shaded.org.eclipse.aether.util.artifact.DefaultArtifactTypeRegistry;
import shaded.org.eclipse.aether.util.graph.manager.ClassicDependencyManager;
import shaded.org.eclipse.aether.util.graph.transformer.ChainedDependencyGraphTransformer;
import shaded.org.eclipse.aether.util.graph.transformer.ConflictResolver;
import shaded.org.eclipse.aether.util.graph.transformer.JavaDependencyContextRefiner;
import shaded.org.eclipse.aether.util.graph.transformer.JavaScopeDeriver;
import shaded.org.eclipse.aether.util.graph.transformer.JavaScopeSelector;
import shaded.org.eclipse.aether.util.graph.transformer.NearestVersionSelector;
import shaded.org.eclipse.aether.util.graph.transformer.SimpleOptionalitySelector;
import shaded.org.eclipse.aether.util.graph.traverser.FatArtifactTraverser;
import shaded.org.eclipse.aether.util.repository.DefaultMirrorSelector;
import shaded.org.eclipse.aether.util.repository.DefaultProxySelector;
import shaded.org.eclipse.aether.util.repository.SimpleArtifactDescriptorPolicy;
import shaded.org.jboss.shrinkwrap.resolver.impl.maven.aether.ClasspathWorkspaceReader;
import shaded.org.jboss.shrinkwrap.resolver.impl.maven.bootstrap.SecurityActions;
import shaded.org.jboss.shrinkwrap.resolver.impl.maven.convert.MavenConverter;
import shaded.org.jboss.shrinkwrap.resolver.impl.maven.logging.LogRepositoryListener;
import shaded.org.jboss.shrinkwrap.resolver.impl.maven.logging.LogTransferListener;
import shaded.org.jboss.shrinkwrap.resolver.impl.maven.util.Validate;

class MavenManagerBuilder {
    public static final String USE_LEGACY_REPO_KEY = "maven.legacyLocalRepo";
    private final Settings settings;
    private final RepositorySystem system;
    private final boolean useLegacyLocalRepository;

    MavenManagerBuilder(RepositorySystem system, Settings settings) {
        this.system = system;
        this.settings = settings;
        this.useLegacyLocalRepository = Boolean.parseBoolean(SecurityActions.getProperty(USE_LEGACY_REPO_KEY));
    }

    public TransferListener transferListerer() {
        return new LogTransferListener();
    }

    public RepositoryListener repositoryListener() {
        return new LogRepositoryListener();
    }

    public LocalRepositoryManager localRepositoryManager(RepositorySystemSession session, boolean legacyLocalRepository) {
        Validate.notNull(session, "session must be specified");
        String localRepositoryPath = this.settings.getLocalRepository();
        Validate.notNullOrEmpty(localRepositoryPath, "Path to a local repository must be defined");
        SWRLocalRepositoryManager factory = SWRLocalRepositoryManager.ENHANCED;
        if (this.useLegacyLocalRepository || legacyLocalRepository) {
            factory = SWRLocalRepositoryManager.LEGACY;
        }
        if (this.settings.isOffline()) {
            factory = SWRLocalRepositoryManager.SIMPLE;
        }
        LocalRepositoryManager manager = factory.localRepositoryManager(this.system, session, new File(localRepositoryPath));
        return manager;
    }

    public MirrorSelector mirrorSelector() {
        DefaultMirrorSelector dms = new DefaultMirrorSelector();
        for (Mirror mirror : this.settings.getMirrors()) {
            dms.add(mirror.getId(), mirror.getUrl(), mirror.getLayout(), false, false, mirror.getMirrorOf(), mirror.getMirrorOfLayouts());
        }
        return dms;
    }

    public ProxySelector proxySelector() {
        DefaultProxySelector dps = new DefaultProxySelector();
        for (Proxy proxy : this.settings.getProxies()) {
            dps.add(MavenConverter.asProxy(proxy), proxy.getNonProxyHosts());
        }
        return dps;
    }

    public WorkspaceReader workspaceReader() {
        return new ClasspathWorkspaceReader();
    }

    public DependencyManager dependencyManager() {
        return new ClassicDependencyManager();
    }

    public ArtifactDescriptorPolicy artifactRepositoryPolicy() {
        return new SimpleArtifactDescriptorPolicy(true, true);
    }

    public ArtifactTypeRegistry artifactTypeRegistry() {
        DefaultArtifactTypeRegistry stereotypes = new DefaultArtifactTypeRegistry();
        stereotypes.add(new DefaultArtifactType("pom"));
        stereotypes.add(new DefaultArtifactType("maven-plugin", "jar", "", "java"));
        stereotypes.add(new DefaultArtifactType("jar", "jar", "", "java"));
        stereotypes.add(new DefaultArtifactType("ejb", "jar", "", "java"));
        stereotypes.add(new DefaultArtifactType("ejb-client", "jar", "client", "java"));
        stereotypes.add(new DefaultArtifactType("test-jar", "jar", "tests", "java"));
        stereotypes.add(new DefaultArtifactType("javadoc", "jar", "javadoc", "java"));
        stereotypes.add(new DefaultArtifactType("java-source", "jar", "sources", "java", false, false));
        stereotypes.add(new DefaultArtifactType("war", "war", "", "java", false, true));
        stereotypes.add(new DefaultArtifactType("ear", "ear", "", "java", false, true));
        stereotypes.add(new DefaultArtifactType("rar", "rar", "", "java", false, true));
        stereotypes.add(new DefaultArtifactType("par", "par", "", "java", false, true));
        return stereotypes;
    }

    public DependencyTraverser dependencyTraverser() {
        return new FatArtifactTraverser();
    }

    public DependencyGraphTransformer dependencyGraphTransformer() {
        ConflictResolver transformer = new ConflictResolver(new NearestVersionSelector(), new JavaScopeSelector(), new SimpleOptionalitySelector(), new JavaScopeDeriver());
        return new ChainedDependencyGraphTransformer(transformer, new JavaDependencyContextRefiner());
    }

    private static enum SWRLocalRepositoryManager {
        SIMPLE{

            @Override
            public LocalRepositoryManager localRepositoryManager(RepositorySystem system, RepositorySystemSession session, File localRepositoryPath) {
                return system.newLocalRepositoryManager(session, new LocalRepository(localRepositoryPath, "simple"));
            }
        }
        ,
        ENHANCED{

            @Override
            public LocalRepositoryManager localRepositoryManager(RepositorySystem system, RepositorySystemSession session, File localRepositoryPath) {
                return system.newLocalRepositoryManager(session, new LocalRepository(localRepositoryPath, "default"));
            }
        }
        ,
        LEGACY{

            @Override
            public LocalRepositoryManager localRepositoryManager(RepositorySystem system, RepositorySystemSession session, File localRepositoryPath) {
                return system.newLocalRepositoryManager(session, new LocalRepository(localRepositoryPath, "simple"));
            }
        };


        public abstract LocalRepositoryManager localRepositoryManager(RepositorySystem var1, RepositorySystemSession var2, File var3);
    }
}

