/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.jboss.shrinkwrap.resolver.impl.maven.util;

import java.io.File;
import java.util.Collection;

public final class Validate {
    private Validate() {
    }

    public static void notNull(Object obj, String message) throws IllegalArgumentException {
        if (obj == null) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void stateNotNull(Object obj, String message) throws IllegalStateException {
        if (obj == null) {
            throw new IllegalStateException(message);
        }
    }

    public static void notEmpty(Collection<?> collection, String message) throws IllegalArgumentException {
        if (collection == null || collection.size() == 0) {
            throw new IllegalArgumentException(message);
        }
    }

    public static boolean isNullOrEmpty(String string) {
        return string == null || string.length() == 0;
    }

    public static boolean isNullOrEmptyOrQuestionMark(String string) {
        return string == null || string.length() == 0 || "?".equals(string);
    }

    public static void notNullOrEmpty(String string, String message) throws IllegalArgumentException {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void readable(String path, String message) throws IllegalArgumentException {
        Validate.notNullOrEmpty(path, message);
        Validate.readable(new File(path), message);
    }

    public static void readable(File path, String message) throws IllegalArgumentException {
        Validate.notNull(path, message);
        if (!Validate.isReadable(path)) {
            throw new IllegalArgumentException(message);
        }
    }

    public static boolean isReadable(File path) {
        return path != null && path.exists() && path.canRead();
    }

    public static void writeableDirectory(String path, String message) throws IllegalArgumentException {
        Validate.notNullOrEmpty(path, message);
        File file = new File(path);
        if (!(file.exists() && file.isDirectory() && file.canWrite() && file.canExecute())) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void notNullAndNoNullValues(Object[] objects, String message) {
        Validate.notNull(objects, message);
        for (Object object : objects) {
            Validate.notNull(object, message);
        }
    }

    public static void isReadable(File file, String message) throws IllegalArgumentException {
        Validate.notNull(file, message);
        if (!(file.exists() && file.isFile() && file.canRead())) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void isReadable(String path, String message) throws IllegalArgumentException {
        Validate.notNullOrEmpty(path, message);
        Validate.isReadable(new File(path), message);
    }
}

