/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.eclipse.sisu.plexus;

import java.util.List;
import shaded.com.google.inject.TypeLiteral;
import shaded.com.google.inject.spi.InjectionListener;
import shaded.com.google.inject.spi.TypeEncounter;
import shaded.org.eclipse.sisu.bean.BeanBinder;
import shaded.org.eclipse.sisu.bean.BeanManager;
import shaded.org.eclipse.sisu.bean.PropertyBinder;
import shaded.org.eclipse.sisu.plexus.PlexusBeanMetadata;
import shaded.org.eclipse.sisu.plexus.PlexusBeanSource;
import shaded.org.eclipse.sisu.plexus.PlexusPropertyBinder;

final class PlexusBeanBinder
implements BeanBinder,
InjectionListener<Object> {
    private final BeanManager manager;
    private final PlexusBeanSource[] sources;

    PlexusBeanBinder(BeanManager manager, List<PlexusBeanSource> sources) {
        this.manager = manager;
        this.sources = sources.toArray(new PlexusBeanSource[sources.size()]);
    }

    @Override
    public <B> PropertyBinder bindBean(TypeLiteral<B> type, TypeEncounter<B> encounter) {
        Class<B> clazz = type.getRawType();
        if (this.manager != null && this.manager.manage(clazz)) {
            encounter.register(this);
        }
        PlexusBeanSource[] plexusBeanSourceArray = this.sources;
        int n = this.sources.length;
        int n2 = 0;
        while (n2 < n) {
            PlexusBeanSource source = plexusBeanSourceArray[n2];
            PlexusBeanMetadata metadata = source.getBeanMetadata(clazz);
            if (metadata != null) {
                return new PlexusPropertyBinder(this.manager, encounter, metadata);
            }
            ++n2;
        }
        return null;
    }

    @Override
    public void afterInjection(Object bean) {
        this.manager.manage(bean);
    }
}

