/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.eclipse.sisu.plexus;

import java.util.ArrayList;
import java.util.Map;
import shaded.com.google.inject.Binder;
import shaded.com.google.inject.Module;
import shaded.javax.inject.Inject;
import shaded.javax.inject.Provider;
import shaded.org.codehaus.plexus.PlexusContainer;
import shaded.org.codehaus.plexus.context.Context;
import shaded.org.codehaus.plexus.context.ContextMapAdapter;
import shaded.org.codehaus.plexus.context.DefaultContext;
import shaded.org.codehaus.plexus.logging.LoggerManager;
import shaded.org.eclipse.sisu.Parameters;
import shaded.org.eclipse.sisu.bean.BeanManager;
import shaded.org.eclipse.sisu.inject.DeferredProvider;
import shaded.org.eclipse.sisu.plexus.DefaultPlexusBeanLocator;
import shaded.org.eclipse.sisu.plexus.PlexusAnnotatedBeanModule;
import shaded.org.eclipse.sisu.plexus.PlexusBeanConverter;
import shaded.org.eclipse.sisu.plexus.PlexusBeanLocator;
import shaded.org.eclipse.sisu.plexus.PlexusBeanModule;
import shaded.org.eclipse.sisu.plexus.PlexusBindingModule;
import shaded.org.eclipse.sisu.plexus.PlexusLifecycleManager;
import shaded.org.eclipse.sisu.plexus.PlexusXmlBeanConverter;
import shaded.org.eclipse.sisu.plexus.PlexusXmlBeanModule;
import shaded.org.eclipse.sisu.plexus.PseudoPlexusContainer;
import shaded.org.eclipse.sisu.space.BeanScanning;
import shaded.org.eclipse.sisu.space.ClassSpace;

public final class PlexusSpaceModule
implements Module {
    private final ClassSpace space;
    private final BeanScanning scanning;
    private BeanManager delegate;

    public PlexusSpaceModule(ClassSpace space) {
        this(space, BeanScanning.OFF);
    }

    public PlexusSpaceModule(ClassSpace space, BeanScanning scanning) {
        this.space = space;
        this.scanning = scanning;
    }

    @Override
    public void configure(Binder binder) {
        ParameterizedContext context = new ParameterizedContext();
        binder.bind(Context.class).toInstance(context);
        DeferredProvider<?> slf4jLoggerFactoryProvider = this.space.deferLoadClass("shaded.org.slf4j.ILoggerFactory").asProvider();
        binder.requestInjection(slf4jLoggerFactoryProvider);
        binder.bind(PlexusBeanConverter.class).to(PlexusXmlBeanConverter.class);
        binder.bind(PlexusBeanLocator.class).to(DefaultPlexusBeanLocator.class);
        binder.bind(PlexusContainer.class).to(PseudoPlexusContainer.class);
        BeanManager manager = this.delegate instanceof PlexusLifecycleManager ? this.delegate : new PlexusLifecycleManager((Provider<Context>)((Object)binder.getProvider(Context.class)), (Provider<LoggerManager>)((Object)binder.getProvider(LoggerManager.class)), (Provider<?>)((Object)slf4jLoggerFactoryProvider), this.delegate);
        binder.bind(BeanManager.class).toInstance(manager);
        ArrayList<PlexusBeanModule> beanModules = new ArrayList<PlexusBeanModule>();
        ContextMapAdapter variables = new ContextMapAdapter(context);
        beanModules.add(new PlexusXmlBeanModule(this.space, variables));
        beanModules.add(new PlexusAnnotatedBeanModule(this.space, variables, this.scanning));
        binder.install(new PlexusBindingModule(manager, beanModules));
    }

    public PlexusSpaceModule with(BeanManager manager) {
        this.delegate = manager;
        return this;
    }

    static final class ParameterizedContext
    extends DefaultContext {
        ParameterizedContext() {
        }

        @Inject
        protected void setParameters(@Parameters Map parameters, PlexusContainer container) {
            this.contextData.putAll(parameters);
            this.contextData.put("plexus", container);
        }
    }
}

