/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.jboss.shrinkwrap.resolver.impl.maven.task;

import java.io.File;
import shaded.org.jboss.shrinkwrap.resolver.api.InvalidConfigurationFileException;
import shaded.org.jboss.shrinkwrap.resolver.api.maven.MavenWorkingSession;
import shaded.org.jboss.shrinkwrap.resolver.impl.maven.task.MavenWorkingSessionTask;
import shaded.org.jboss.shrinkwrap.resolver.impl.maven.util.Validate;

public class ConfigureSettingsFromFileTask
implements MavenWorkingSessionTask<MavenWorkingSession> {
    private final File settingsXmlFile;

    public ConfigureSettingsFromFileTask(File settingsXmlFile) throws InvalidConfigurationFileException {
        assert (settingsXmlFile != null);
        assert (settingsXmlFile.exists());
        this.settingsXmlFile = settingsXmlFile;
    }

    public ConfigureSettingsFromFileTask(String pathToSettingsXmlFile) throws InvalidConfigurationFileException {
        assert (pathToSettingsXmlFile != null && !pathToSettingsXmlFile.isEmpty());
        String resolvedPath = null;
        try {
            resolvedPath = pathToSettingsXmlFile;
            Validate.isReadable(resolvedPath, "Path to the settings.xml ('" + pathToSettingsXmlFile + "') must be defined and accessible");
        }
        catch (IllegalArgumentException e) {
            throw new InvalidConfigurationFileException(e.getMessage());
        }
        this.settingsXmlFile = new File(resolvedPath);
    }

    @Override
    public MavenWorkingSession execute(MavenWorkingSession session) {
        try {
            Validate.isReadable(this.settingsXmlFile, "Path to the settings.xml ('" + this.settingsXmlFile + "') must be defined and accessible");
        }
        catch (IllegalArgumentException e) {
            throw new InvalidConfigurationFileException(e.getMessage());
        }
        return session.configureSettingsFromFile(null, this.settingsXmlFile);
    }
}

