/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.jboss.shrinkwrap.resolver.impl.maven.task;

import java.text.MessageFormat;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import shaded.org.jboss.shrinkwrap.resolver.api.ResolutionException;
import shaded.org.jboss.shrinkwrap.resolver.api.maven.MavenWorkingSession;
import shaded.org.jboss.shrinkwrap.resolver.api.maven.PackagingType;
import shaded.org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenCoordinate;
import shaded.org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenCoordinates;
import shaded.org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenDependency;
import shaded.org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenDependencyExclusion;
import shaded.org.jboss.shrinkwrap.resolver.impl.maven.coordinate.MavenDependencyImpl;
import shaded.org.jboss.shrinkwrap.resolver.impl.maven.task.MavenWorkingSessionTask;
import shaded.org.jboss.shrinkwrap.resolver.impl.maven.util.Validate;

public class ResolveVersionFromMetadataTask
implements MavenWorkingSessionTask<String> {
    private static final Logger log = Logger.getLogger(ResolveVersionFromMetadataTask.class.getName());
    private final MavenDependency dependency;

    public ResolveVersionFromMetadataTask(MavenDependency dependency) {
        this.dependency = dependency;
    }

    @Override
    public String execute(MavenWorkingSession session) {
        String declaredVersion = this.dependency.getVersion();
        String resolvedVersion = declaredVersion;
        if (Validate.isNullOrEmptyOrQuestionMark(resolvedVersion) && session.getDependencyManagement().contains(this.dependency)) {
            MavenDependency mavenDependency;
            MavenCoordinate resolved = null;
            Iterator<MavenDependency> iterator = session.getDependencyManagement().iterator();
            while (iterator.hasNext() && !((Object)(resolved = (mavenDependency = iterator.next()))).equals(this.dependency)) {
            }
            if (resolved != null) {
                resolvedVersion = resolved.getVersion();
                log.log(Level.FINE, "Resolved version {0} from the POM file for the artifact {1}", new Object[]{resolved.getVersion(), this.dependency.toCanonicalForm()});
            }
        }
        if (Validate.isNullOrEmptyOrQuestionMark(resolvedVersion) && this.dependency.getPackaging().equals(PackagingType.JAR) && this.dependency.getClassifier().equals(PackagingType.TEST_JAR.getClassifier())) {
            MavenCoordinate coordinate = MavenCoordinates.createCoordinate(this.dependency.getGroupId(), this.dependency.getArtifactId(), this.dependency.getVersion(), PackagingType.TEST_JAR, PackagingType.TEST_JAR.getClassifier());
            MavenDependencyImpl newDependency = new MavenDependencyImpl(coordinate, this.dependency.getScope(), this.dependency.isOptional(), this.dependency.getExclusions().toArray(new MavenDependencyExclusion[0]));
            if (session.getDependencyManagement().contains(newDependency)) {
                MavenDependency mavenDependency;
                MavenCoordinate resolved = null;
                Iterator<MavenDependency> iterator = session.getDependencyManagement().iterator();
                while (iterator.hasNext() && !((Object)(resolved = (mavenDependency = iterator.next()))).equals(newDependency)) {
                }
                if (resolved != null) {
                    resolvedVersion = resolved.getVersion();
                    log.log(Level.FINE, "Resolved version {0} from the POM file for the artifact {1} via {2}", new Object[]{resolved.getVersion(), this.dependency.toCanonicalForm(), newDependency.toCanonicalForm()});
                }
            }
        }
        if (Validate.isNullOrEmptyOrQuestionMark(resolvedVersion)) {
            if (log.isLoggable(Level.FINER)) {
                StringBuilder sb = new StringBuilder("Available version management: \n");
                for (MavenDependency depmgmt : session.getDependencyManagement()) {
                    sb.append(depmgmt).append("\n");
                }
                log.log(Level.FINER, sb.toString());
            }
            throw new ResolutionException(MessageFormat.format("Unable to get version for dependency specified by {0}, it was not provided in neither <dependencyManagement> nor <dependencies> sections.", this.dependency.toCanonicalForm()));
        }
        return resolvedVersion;
    }
}

