/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.mima.runtime.shared;

import eu.maveniverse.maven.mima.context.Context;
import eu.maveniverse.maven.mima.context.ContextOverrides;
import eu.maveniverse.maven.mima.context.HTTPProxy;
import eu.maveniverse.maven.mima.context.Lookup;
import eu.maveniverse.maven.mima.context.MavenSystemHome;
import eu.maveniverse.maven.mima.context.MavenUserHome;
import eu.maveniverse.maven.mima.context.internal.MavenSystemHomeImpl;
import eu.maveniverse.maven.mima.context.internal.MavenUserHomeImpl;
import eu.maveniverse.maven.mima.context.internal.RuntimeSupport;
import eu.maveniverse.maven.mima.runtime.shared.PreBoot;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import shaded.org.apache.maven.model.Activation;
import shaded.org.apache.maven.model.ActivationFile;
import shaded.org.apache.maven.model.Profile;
import shaded.org.apache.maven.model.Repository;
import shaded.org.apache.maven.model.building.ModelProblemCollector;
import shaded.org.apache.maven.model.building.ModelProblemCollectorRequest;
import shaded.org.apache.maven.model.profile.DefaultProfileActivationContext;
import shaded.org.apache.maven.model.profile.ProfileSelector;
import shaded.org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import shaded.org.apache.maven.settings.ActivationOS;
import shaded.org.apache.maven.settings.ActivationProperty;
import shaded.org.apache.maven.settings.IdentifiableBase;
import shaded.org.apache.maven.settings.Mirror;
import shaded.org.apache.maven.settings.RepositoryPolicy;
import shaded.org.apache.maven.settings.Server;
import shaded.org.apache.maven.settings.Settings;
import shaded.org.apache.maven.settings.building.DefaultSettingsBuildingRequest;
import shaded.org.apache.maven.settings.building.SettingsBuilder;
import shaded.org.apache.maven.settings.building.SettingsBuildingException;
import shaded.org.apache.maven.settings.building.SettingsProblem;
import shaded.org.apache.maven.settings.crypto.DefaultSettingsDecryptionRequest;
import shaded.org.apache.maven.settings.crypto.SettingsDecrypter;
import shaded.org.apache.maven.settings.crypto.SettingsDecryptionResult;
import shaded.org.apache.maven.settings.merge.MavenSettingsMerger;
import shaded.org.codehaus.plexus.util.xml.Xpp3Dom;
import shaded.org.eclipse.aether.DefaultRepositoryCache;
import shaded.org.eclipse.aether.DefaultRepositorySystemSession;
import shaded.org.eclipse.aether.RepositorySystem;
import shaded.org.eclipse.aether.repository.Proxy;
import shaded.org.eclipse.aether.repository.RemoteRepository;
import shaded.org.eclipse.aether.util.artifact.DefaultArtifactTypeRegistry;
import shaded.org.eclipse.aether.util.repository.AuthenticationBuilder;
import shaded.org.eclipse.aether.util.repository.DefaultAuthenticationSelector;
import shaded.org.eclipse.aether.util.repository.DefaultMirrorSelector;
import shaded.org.eclipse.aether.util.repository.DefaultProxySelector;
import shaded.org.eclipse.aether.util.repository.SimpleResolutionErrorPolicy;
import shaded.org.slf4j.Logger;
import shaded.org.slf4j.LoggerFactory;

public abstract class StandaloneRuntimeSupport
extends RuntimeSupport {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    protected StandaloneRuntimeSupport(String name, int priority) {
        super(name, StandaloneRuntimeSupport.discoverVersion(), priority, StandaloneRuntimeSupport.discoverMavenVersion());
    }

    private static String discoverVersion() {
        Map<String, String> version = StandaloneRuntimeSupport.loadClasspathProperties("/eu/maveniverse/maven/mima/runtime/shared/internal/version.properties");
        String result = version.get("version");
        if (result == null || result.trim().isEmpty() || result.startsWith("${")) {
            return "(unknown)";
        }
        return result;
    }

    protected PreBoot preBoot(ContextOverrides overrides) {
        Path mavenSystemHome;
        String localRepoPath;
        Map<String, String> systemProperties = StandaloneRuntimeSupport.defaultSystemProperties();
        systemProperties.putAll(overrides.getSystemProperties());
        HashMap<String, String> userProperties = new HashMap<String, String>(overrides.getUserProperties());
        HashMap<String, Object> configProperties = new HashMap<String, Object>(systemProperties);
        configProperties.putAll(userProperties);
        configProperties.putAll(overrides.getConfigProperties());
        Path localRepositoryOverride = StandaloneRuntimeSupport.safeAbsolute(overrides.getLocalRepositoryOverride());
        if (localRepositoryOverride == null && (localRepoPath = (String)configProperties.get("maven.repo.local")) != null) {
            localRepositoryOverride = Paths.get(localRepoPath, new String[0]).toAbsolutePath();
        }
        if ((mavenSystemHome = StandaloneRuntimeSupport.safeAbsolute(overrides.getMavenSystemHomeOverride())) == null) {
            String mavenHome = (String)configProperties.get("maven.home");
            if (mavenHome == null) {
                mavenHome = (String)configProperties.get("env.MAVEN_HOME");
            }
            if (mavenHome != null) {
                mavenSystemHome = Paths.get(mavenHome, new String[0]).toAbsolutePath();
            }
        }
        ContextOverrides alteredOverrides = overrides.toBuilder().systemProperties(systemProperties).userProperties(userProperties).configProperties(configProperties).withLocalRepositoryOverride(localRepositoryOverride).build();
        MavenUserHomeImpl mavenUserHomeImpl = this.defaultMavenUserHome().derive(alteredOverrides);
        MavenSystemHomeImpl mavenSystemHomeImpl = mavenSystemHome != null ? new MavenSystemHomeImpl(mavenSystemHome).derive(alteredOverrides) : null;
        Path baseDir = alteredOverrides.getBasedirOverride() != null ? alteredOverrides.getBasedirOverride() : DEFAULT_BASEDIR;
        return new PreBoot(alteredOverrides, mavenUserHomeImpl, mavenSystemHomeImpl, baseDir);
    }

    protected Context buildContext(StandaloneRuntimeSupport runtime, PreBoot preBoot, RepositorySystem repositorySystem, SettingsBuilder settingsBuilder, SettingsDecrypter settingsDecrypter, ProfileSelector profileSelector, Lookup lookup, Runnable managedCloser) {
        try {
            List<shaded.org.apache.maven.settings.Profile> activeProfiles;
            ContextOverrides alteredOverrides = preBoot.getOverrides();
            MavenUserHomeImpl mavenUserHomeImpl = preBoot.getMavenUserHome();
            MavenSystemHomeImpl mavenSystemHomeImpl = preBoot.getMavenSystemHome();
            Path baseDir = preBoot.getBaseDir();
            Settings settings = this.newEffectiveSettings(alteredOverrides, mavenUserHomeImpl, mavenSystemHomeImpl, settingsBuilder);
            if (settings.getLocalRepository() != null && alteredOverrides.getLocalRepositoryOverride() == null) {
                mavenUserHomeImpl = mavenUserHomeImpl.withLocalRepository(Paths.get(settings.getLocalRepository(), new String[0]).toAbsolutePath());
            }
            shaded.org.apache.maven.settings.Proxy proxy = settings.getActiveProxy();
            HTTPProxy httpProxy = null;
            if (proxy != null) {
                httpProxy = this.toHTTPProxy(proxy);
            }
            if (!(activeProfiles = this.activeProfilesByActivation(alteredOverrides, baseDir, settings, profileSelector)).isEmpty()) {
                alteredOverrides = alteredOverrides.toBuilder().withActiveProfileIds(activeProfiles.stream().map(IdentifiableBase::getId).collect(Collectors.toList())).build();
            }
            HashMap<String, String> profileProperties = new HashMap<String, String>();
            for (shaded.org.apache.maven.settings.Profile profile : activeProfiles) {
                profile.getProperties().stringPropertyNames().forEach(n -> profileProperties.put((String)n, profile.getProperties().getProperty((String)n)));
            }
            if (!profileProperties.isEmpty()) {
                HashMap<String, String> profileUserProperties = new HashMap<String, String>(alteredOverrides.getUserProperties());
                profileProperties.forEach(profileUserProperties::putIfAbsent);
                alteredOverrides = alteredOverrides.toBuilder().userProperties(profileUserProperties).build();
            }
            DefaultRepositorySystemSession session = this.newRepositorySession(alteredOverrides, mavenUserHomeImpl, repositorySystem, settings, settingsDecrypter);
            LinkedHashMap<String, RemoteRepository> remoteRepositories = new LinkedHashMap<String, RemoteRepository>();
            if (alteredOverrides.addRepositoriesOp() != ContextOverrides.AddRepositoriesOp.REPLACE) {
                if (alteredOverrides.addRepositoriesOp() == ContextOverrides.AddRepositoriesOp.PREPEND) {
                    alteredOverrides.getRepositories().forEach(r -> remoteRepositories.put(r.getId(), (RemoteRepository)r));
                }
                for (shaded.org.apache.maven.settings.Profile profile : activeProfiles) {
                    for (shaded.org.apache.maven.settings.Repository repository : profile.getRepositories()) {
                        RemoteRepository.Builder builder = new RemoteRepository.Builder(repository.getId(), repository.getLayout(), repository.getUrl());
                        if (repository.getReleases() != null) {
                            builder.setReleasePolicy(new shaded.org.eclipse.aether.repository.RepositoryPolicy(repository.getReleases().isEnabled(), "daily", "warn"));
                        } else {
                            builder.setReleasePolicy(new shaded.org.eclipse.aether.repository.RepositoryPolicy());
                        }
                        if (repository.getSnapshots() != null) {
                            builder.setSnapshotPolicy(new shaded.org.eclipse.aether.repository.RepositoryPolicy(repository.getSnapshots().isEnabled(), "daily", "warn"));
                        } else {
                            builder.setSnapshotPolicy(new shaded.org.eclipse.aether.repository.RepositoryPolicy(false, null, null));
                        }
                        RemoteRepository remoteRepository = builder.build();
                        remoteRepositories.put(remoteRepository.getId(), remoteRepository);
                    }
                }
                if (alteredOverrides.addRepositoriesOp() == ContextOverrides.AddRepositoriesOp.APPEND) {
                    alteredOverrides.getRepositories().forEach(r -> remoteRepositories.put(r.getId(), (RemoteRepository)r));
                }
            } else {
                alteredOverrides.getRepositories().forEach(r -> remoteRepositories.put(r.getId(), (RemoteRepository)r));
            }
            return new Context(runtime, alteredOverrides, baseDir, mavenUserHomeImpl, mavenSystemHomeImpl, repositorySystem, session, Collections.unmodifiableList(repositorySystem.newResolutionRepositories(session, new ArrayList<RemoteRepository>(remoteRepositories.values()))), httpProxy, lookup, managedCloser);
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot create context from scratch", e);
        }
    }

    private HTTPProxy toHTTPProxy(shaded.org.apache.maven.settings.Proxy proxy) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        if (proxy.getUsername() != null) {
            data.put("username", proxy.getUsername());
        }
        if (proxy.getPassword() != null) {
            data.put("password", proxy.getPassword());
        }
        return new HTTPProxy(proxy.getProtocol(), proxy.getHost(), proxy.getPort(), proxy.getNonProxyHosts(), data);
    }

    protected Settings newEffectiveSettings(ContextOverrides overrides, MavenUserHome mavenUserHome, MavenSystemHome mavenSystemHome, SettingsBuilder settingsBuilder) throws SettingsBuildingException {
        if (!overrides.isWithUserSettings()) {
            return new Settings();
        }
        if (overrides.getEffectiveSettings() instanceof Settings) {
            return (Settings)overrides.getEffectiveSettings();
        }
        DefaultSettingsBuildingRequest settingsBuilderRequest = new DefaultSettingsBuildingRequest();
        Properties systemProperties = new Properties();
        systemProperties.putAll(overrides.getSystemProperties());
        settingsBuilderRequest.setSystemProperties(systemProperties);
        Properties userProperties = new Properties();
        userProperties.putAll(overrides.getUserProperties());
        settingsBuilderRequest.setUserProperties(userProperties);
        if (mavenSystemHome != null) {
            settingsBuilderRequest.setGlobalSettingsFile(mavenSystemHome.settingsXml().toFile());
        }
        settingsBuilderRequest.setUserSettingsFile(mavenUserHome.settingsXml().toFile());
        Settings result = settingsBuilder.build(settingsBuilderRequest).getEffectiveSettings();
        if (overrides.getEffectiveSettingsMixin() instanceof Settings) {
            this.settingsMixin(result, (Settings)overrides.getEffectiveSettingsMixin());
        }
        return result;
    }

    protected void settingsMixin(Settings settings, Settings mixin) {
        boolean mixinAddsProxy;
        boolean bl = mixinAddsProxy = !mixin.getProxies().isEmpty();
        if (mixinAddsProxy) {
            for (shaded.org.apache.maven.settings.Proxy proxy : settings.getProxies()) {
                proxy.setActive(false);
            }
            settings.flushActiveProxy();
        }
        new MavenSettingsMerger().merge(settings, mixin, "global-level");
    }

    protected List<shaded.org.apache.maven.settings.Profile> activeProfilesByActivation(ContextOverrides overrides, Path basedir, Settings settings, ProfileSelector profileSelector) {
        if (profileSelector == null) {
            return this.activeProfiles(settings);
        }
        DefaultProfileActivationContext context = new DefaultProfileActivationContext();
        context.setProjectDirectory(basedir.toFile());
        context.setActiveProfileIds(Stream.concat(settings.getActiveProfiles().stream(), overrides.getActiveProfileIds().stream()).distinct().collect(Collectors.toList()));
        context.setInactiveProfileIds(overrides.getInactiveProfileIds());
        context.setSystemProperties(overrides.getSystemProperties());
        context.setUserProperties(overrides.getUserProperties());
        ModelProblemCollector collector = new ModelProblemCollector(){

            @Override
            public void add(ModelProblemCollectorRequest req) {
            }
        };
        return profileSelector.getActiveProfiles(settings.getProfiles().stream().map(StandaloneRuntimeSupport::convertFromSettingsProfile).collect(Collectors.toList()), context, collector).stream().map(StandaloneRuntimeSupport::convertToSettingsProfile).collect(Collectors.toList());
    }

    protected List<shaded.org.apache.maven.settings.Profile> activeProfiles(Settings settings) {
        HashMap<String, shaded.org.apache.maven.settings.Profile> result = new HashMap<String, shaded.org.apache.maven.settings.Profile>();
        Map<String, shaded.org.apache.maven.settings.Profile> profileMap = settings.getProfilesAsMap();
        for (String profileId : settings.getActiveProfiles()) {
            shaded.org.apache.maven.settings.Profile profile = profileMap.get(profileId);
            if (profile == null) continue;
            result.put(profile.getId(), profile);
        }
        for (shaded.org.apache.maven.settings.Profile profile : settings.getProfiles()) {
            shaded.org.apache.maven.settings.Activation activation = profile.getActivation();
            if (activation == null || !activation.isActiveByDefault()) continue;
            result.put(profile.getId(), profile);
        }
        return new ArrayList<shaded.org.apache.maven.settings.Profile>(result.values());
    }

    protected DefaultRepositorySystemSession newRepositorySession(ContextOverrides overrides, MavenUserHome mavenUserHome, RepositorySystem repositorySystem, Settings settings, SettingsDecrypter settingsDecrypter) {
        DefaultRepositorySystemSession session = MavenRepositorySystemUtils.newSession();
        if (!overrides.extraArtifactTypes().isEmpty()) {
            DefaultArtifactTypeRegistry registry = (DefaultArtifactTypeRegistry)session.getArtifactTypeRegistry();
            overrides.extraArtifactTypes().forEach(registry::add);
        }
        session.setCache(new DefaultRepositoryCache());
        LinkedHashMap<String, Object> configProps = new LinkedHashMap<String, Object>(overrides.getConfigProperties());
        configProps.putIfAbsent("aether.connector.userAgent", this.getUserAgent());
        configProps.put("aether.interactive", false);
        configProps.put("maven.startTime", new Date());
        session.setOffline(overrides.isOffline());
        session.setIgnoreArtifactDescriptorRepositories(overrides.isIgnoreArtifactDescriptorRepositories());
        this.customizeChecksumPolicy(overrides, session);
        this.customizeSnapshotUpdatePolicy(overrides, session);
        session.setResolutionErrorPolicy(new SimpleResolutionErrorPolicy(false, false));
        DefaultSettingsDecryptionRequest decrypt = new DefaultSettingsDecryptionRequest();
        decrypt.setProxies((List)settings.getProxies());
        decrypt.setServers((List)settings.getServers());
        SettingsDecryptionResult decrypted = settingsDecrypter.decrypt(decrypt);
        if (this.logger.isDebugEnabled()) {
            for (SettingsProblem settingsProblem : decrypted.getProblems()) {
                this.logger.debug(settingsProblem.getMessage(), settingsProblem.getException());
            }
        }
        DefaultMirrorSelector mirrorSelector = new DefaultMirrorSelector();
        for (Mirror mirror : settings.getMirrors()) {
            mirrorSelector.add(mirror.getId(), mirror.getUrl(), mirror.getLayout(), false, mirror.isBlocked(), mirror.getMirrorOf(), mirror.getMirrorOfLayouts());
        }
        session.setMirrorSelector(mirrorSelector);
        DefaultProxySelector defaultProxySelector = new DefaultProxySelector();
        for (shaded.org.apache.maven.settings.Proxy proxy : decrypted.getProxies()) {
            AuthenticationBuilder authBuilder = new AuthenticationBuilder();
            authBuilder.addUsername(proxy.getUsername()).addPassword(proxy.getPassword());
            defaultProxySelector.add(new Proxy(proxy.getProtocol(), proxy.getHost(), proxy.getPort(), authBuilder.build()), proxy.getNonProxyHosts());
        }
        session.setProxySelector(defaultProxySelector);
        DefaultAuthenticationSelector defaultAuthenticationSelector = new DefaultAuthenticationSelector();
        for (Server server : decrypted.getServers()) {
            AuthenticationBuilder authBuilder = new AuthenticationBuilder();
            authBuilder.addUsername(server.getUsername()).addPassword(server.getPassword());
            authBuilder.addPrivateKey(server.getPrivateKey(), server.getPassphrase());
            defaultAuthenticationSelector.add(server.getId(), authBuilder.build());
            if (server.getConfiguration() != null) {
                Xpp3Dom requestTimeoutXml;
                Xpp3Dom connectTimeoutXml;
                Xpp3Dom[] properties;
                Xpp3Dom dom = (Xpp3Dom)server.getConfiguration();
                for (int i = dom.getChildCount() - 1; i >= 0; --i) {
                    Xpp3Dom child = dom.getChild(i);
                    if (!"wagonProvider".equals(child.getName())) continue;
                    dom.removeChild(i);
                }
                HashMap<String, String> headers = null;
                Integer connectTimeout = null;
                Integer requestTimeout = null;
                Xpp3Dom httpHeaders = dom.getChild("httpHeaders");
                if (httpHeaders != null && (properties = httpHeaders.getChildren("property")) != null && properties.length > 0) {
                    headers = new HashMap<String, String>();
                    for (Xpp3Dom property : properties) {
                        headers.put(property.getChild("name").getValue(), property.getChild("value").getValue());
                    }
                }
                if ((connectTimeoutXml = dom.getChild("connectTimeout")) != null) {
                    connectTimeout = Integer.parseInt(connectTimeoutXml.getValue());
                }
                if ((requestTimeoutXml = dom.getChild("requestTimeout")) != null) {
                    requestTimeout = Integer.parseInt(requestTimeoutXml.getValue());
                }
                if (headers != null) {
                    configProps.put("aether.connector.http.headers." + server.getId(), headers);
                }
                if (connectTimeout != null) {
                    configProps.put("aether.connector.connectTimeout." + server.getId(), connectTimeout);
                }
                if (requestTimeout != null) {
                    configProps.put("aether.connector.requestTimeout." + server.getId(), requestTimeout);
                }
            }
            configProps.put("aether.connector.perms.fileMode." + server.getId(), server.getFilePermissions());
            configProps.put("aether.connector.perms.dirMode." + server.getId(), server.getDirectoryPermissions());
        }
        session.setAuthenticationSelector(defaultAuthenticationSelector);
        session.setSystemProperties(overrides.getSystemProperties());
        session.setUserProperties(overrides.getUserProperties());
        session.setConfigProperties(configProps);
        if (overrides.getTransferListener() != null) {
            session.setTransferListener(overrides.getTransferListener());
        }
        if (overrides.getRepositoryListener() != null) {
            session.setRepositoryListener(overrides.getRepositoryListener());
        }
        this.newLocalRepositoryManager(mavenUserHome.localRepository(), repositorySystem, session);
        return session;
    }

    protected String getUserAgent() {
        return "Apache-Maven/" + this.mavenVersion() + " (Java " + System.getProperty("java.version") + "; " + System.getProperty("os.name") + " " + System.getProperty("os.version") + "; MIMA " + this.version() + ")";
    }

    protected static Map<String, String> defaultSystemProperties() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.putAll(System.getenv().entrySet().stream().map(e -> new AbstractMap.SimpleEntry<String, String>("env." + (String)e.getKey(), (String)e.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
        result.putAll(System.getProperties().entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> (String)e.getValue())));
        return result;
    }

    protected static Path safeAbsolute(Path path) {
        if (path == null) {
            return null;
        }
        return path.toAbsolutePath();
    }

    protected static shaded.org.apache.maven.settings.Profile convertToSettingsProfile(Profile modelProfile) {
        List<Repository> pluginRepos;
        shaded.org.apache.maven.settings.Profile profile = new shaded.org.apache.maven.settings.Profile();
        profile.setId(modelProfile.getId());
        Activation modelActivation = modelProfile.getActivation();
        if (modelActivation != null) {
            ActivationFile modelFile;
            shaded.org.apache.maven.model.ActivationOS modelOs;
            shaded.org.apache.maven.settings.Activation activation = new shaded.org.apache.maven.settings.Activation();
            activation.setActiveByDefault(modelActivation.isActiveByDefault());
            activation.setJdk(modelActivation.getJdk());
            shaded.org.apache.maven.model.ActivationProperty modelProp = modelActivation.getProperty();
            if (modelProp != null) {
                ActivationProperty prop = new ActivationProperty();
                prop.setName(modelProp.getName());
                prop.setValue(modelProp.getValue());
                activation.setProperty(prop);
            }
            if ((modelOs = modelActivation.getOs()) != null) {
                ActivationOS os = new ActivationOS();
                os.setArch(modelOs.getArch());
                os.setFamily(modelOs.getFamily());
                os.setName(modelOs.getName());
                os.setVersion(modelOs.getVersion());
                activation.setOs(os);
            }
            if ((modelFile = modelActivation.getFile()) != null) {
                shaded.org.apache.maven.settings.ActivationFile file = new shaded.org.apache.maven.settings.ActivationFile();
                file.setExists(modelFile.getExists());
                file.setMissing(modelFile.getMissing());
                activation.setFile(file);
            }
            profile.setActivation(activation);
        }
        profile.setProperties(modelProfile.getProperties());
        List<Repository> repos = modelProfile.getRepositories();
        if (repos != null) {
            for (Repository repo : repos) {
                profile.addRepository(StandaloneRuntimeSupport.convertToSettingsRepository(repo));
            }
        }
        if ((pluginRepos = modelProfile.getPluginRepositories()) != null) {
            for (Repository pluginRepo : pluginRepos) {
                profile.addPluginRepository(StandaloneRuntimeSupport.convertToSettingsRepository(pluginRepo));
            }
        }
        return profile;
    }

    protected static Profile convertFromSettingsProfile(shaded.org.apache.maven.settings.Profile settingsProfile) {
        List<shaded.org.apache.maven.settings.Repository> pluginRepos;
        Profile profile = new Profile();
        profile.setId(settingsProfile.getId());
        profile.setSource("settings.xml");
        shaded.org.apache.maven.settings.Activation settingsActivation = settingsProfile.getActivation();
        if (settingsActivation != null) {
            shaded.org.apache.maven.settings.ActivationFile settingsFile;
            ActivationOS settingsOs;
            Activation activation = new Activation();
            activation.setActiveByDefault(settingsActivation.isActiveByDefault());
            activation.setJdk(settingsActivation.getJdk());
            ActivationProperty settingsProp = settingsActivation.getProperty();
            if (settingsProp != null) {
                shaded.org.apache.maven.model.ActivationProperty prop = new shaded.org.apache.maven.model.ActivationProperty();
                prop.setName(settingsProp.getName());
                prop.setValue(settingsProp.getValue());
                activation.setProperty(prop);
            }
            if ((settingsOs = settingsActivation.getOs()) != null) {
                shaded.org.apache.maven.model.ActivationOS os = new shaded.org.apache.maven.model.ActivationOS();
                os.setArch(settingsOs.getArch());
                os.setFamily(settingsOs.getFamily());
                os.setName(settingsOs.getName());
                os.setVersion(settingsOs.getVersion());
                activation.setOs(os);
            }
            if ((settingsFile = settingsActivation.getFile()) != null) {
                ActivationFile file = new ActivationFile();
                file.setExists(settingsFile.getExists());
                file.setMissing(settingsFile.getMissing());
                activation.setFile(file);
            }
            profile.setActivation(activation);
        }
        profile.setProperties(settingsProfile.getProperties());
        List<shaded.org.apache.maven.settings.Repository> repos = settingsProfile.getRepositories();
        if (repos != null) {
            for (shaded.org.apache.maven.settings.Repository repo : repos) {
                profile.addRepository(StandaloneRuntimeSupport.convertFromSettingsRepository(repo));
            }
        }
        if ((pluginRepos = settingsProfile.getPluginRepositories()) != null) {
            for (shaded.org.apache.maven.settings.Repository pluginRepo : pluginRepos) {
                profile.addPluginRepository(StandaloneRuntimeSupport.convertFromSettingsRepository(pluginRepo));
            }
        }
        return profile;
    }

    protected static Repository convertFromSettingsRepository(shaded.org.apache.maven.settings.Repository settingsRepo) {
        Repository repo = new Repository();
        repo.setId(settingsRepo.getId());
        repo.setLayout(settingsRepo.getLayout());
        repo.setName(settingsRepo.getName());
        repo.setUrl(settingsRepo.getUrl());
        if (settingsRepo.getSnapshots() != null) {
            repo.setSnapshots(StandaloneRuntimeSupport.convertFromSettingsRepositoryPolicy(settingsRepo.getSnapshots()));
        }
        if (settingsRepo.getReleases() != null) {
            repo.setReleases(StandaloneRuntimeSupport.convertFromSettingsRepositoryPolicy(settingsRepo.getReleases()));
        }
        return repo;
    }

    protected static shaded.org.apache.maven.model.RepositoryPolicy convertFromSettingsRepositoryPolicy(RepositoryPolicy settingsPolicy) {
        shaded.org.apache.maven.model.RepositoryPolicy policy = new shaded.org.apache.maven.model.RepositoryPolicy();
        policy.setEnabled(settingsPolicy.isEnabled());
        policy.setUpdatePolicy(settingsPolicy.getUpdatePolicy());
        policy.setChecksumPolicy(settingsPolicy.getChecksumPolicy());
        return policy;
    }

    protected static shaded.org.apache.maven.settings.Repository convertToSettingsRepository(Repository modelRepo) {
        shaded.org.apache.maven.settings.Repository repo = new shaded.org.apache.maven.settings.Repository();
        repo.setId(modelRepo.getId());
        repo.setLayout(modelRepo.getLayout());
        repo.setName(modelRepo.getName());
        repo.setUrl(modelRepo.getUrl());
        if (modelRepo.getSnapshots() != null) {
            repo.setSnapshots(StandaloneRuntimeSupport.convertToSettingsRepositoryPolicy(modelRepo.getSnapshots()));
        }
        if (modelRepo.getReleases() != null) {
            repo.setReleases(StandaloneRuntimeSupport.convertToSettingsRepositoryPolicy(modelRepo.getReleases()));
        }
        return repo;
    }

    protected static RepositoryPolicy convertToSettingsRepositoryPolicy(shaded.org.apache.maven.model.RepositoryPolicy modelPolicy) {
        RepositoryPolicy policy = new RepositoryPolicy();
        policy.setEnabled(modelPolicy.isEnabled());
        policy.setUpdatePolicy(modelPolicy.getUpdatePolicy());
        policy.setChecksumPolicy(modelPolicy.getChecksumPolicy());
        return policy;
    }
}

