/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.codehaus.plexus.component.configurator.converters.lookup;

import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import shaded.org.codehaus.plexus.component.configurator.ComponentConfigurationException;
import shaded.org.codehaus.plexus.component.configurator.converters.ConfigurationConverter;
import shaded.org.codehaus.plexus.component.configurator.converters.basic.BooleanConverter;
import shaded.org.codehaus.plexus.component.configurator.converters.basic.ByteConverter;
import shaded.org.codehaus.plexus.component.configurator.converters.basic.CharConverter;
import shaded.org.codehaus.plexus.component.configurator.converters.basic.DateConverter;
import shaded.org.codehaus.plexus.component.configurator.converters.basic.DoubleConverter;
import shaded.org.codehaus.plexus.component.configurator.converters.basic.EnumConverter;
import shaded.org.codehaus.plexus.component.configurator.converters.basic.FileConverter;
import shaded.org.codehaus.plexus.component.configurator.converters.basic.FloatConverter;
import shaded.org.codehaus.plexus.component.configurator.converters.basic.IntConverter;
import shaded.org.codehaus.plexus.component.configurator.converters.basic.LongConverter;
import shaded.org.codehaus.plexus.component.configurator.converters.basic.PathConverter;
import shaded.org.codehaus.plexus.component.configurator.converters.basic.ShortConverter;
import shaded.org.codehaus.plexus.component.configurator.converters.basic.StringBufferConverter;
import shaded.org.codehaus.plexus.component.configurator.converters.basic.StringBuilderConverter;
import shaded.org.codehaus.plexus.component.configurator.converters.basic.StringConverter;
import shaded.org.codehaus.plexus.component.configurator.converters.basic.TemporalConverter;
import shaded.org.codehaus.plexus.component.configurator.converters.basic.UriConverter;
import shaded.org.codehaus.plexus.component.configurator.converters.basic.UrlConverter;
import shaded.org.codehaus.plexus.component.configurator.converters.composite.ArrayConverter;
import shaded.org.codehaus.plexus.component.configurator.converters.composite.CollectionConverter;
import shaded.org.codehaus.plexus.component.configurator.converters.composite.MapConverter;
import shaded.org.codehaus.plexus.component.configurator.converters.composite.ObjectWithFieldsConverter;
import shaded.org.codehaus.plexus.component.configurator.converters.composite.PlexusConfigurationConverter;
import shaded.org.codehaus.plexus.component.configurator.converters.composite.PropertiesConverter;
import shaded.org.codehaus.plexus.component.configurator.converters.lookup.ConverterLookup;
import shaded.org.codehaus.plexus.component.configurator.converters.special.ClassRealmConverter;
import shaded.org.eclipse.sisu.inject.Weak;

public final class DefaultConverterLookup
implements ConverterLookup {
    private static final ConfigurationConverter[] DEFAULT_CONVERTERS = new ConfigurationConverter[]{new FileConverter(), new BooleanConverter(), new StringConverter(), new IntConverter(), new CollectionConverter(), new ArrayConverter(), new MapConverter(), new PropertiesConverter(), new UrlConverter(), new UriConverter(), new PathConverter(), new DateConverter(), new EnumConverter(), new LongConverter(), new FloatConverter(), new DoubleConverter(), new CharConverter(), new ByteConverter(), new ShortConverter(), new PlexusConfigurationConverter(), new ClassRealmConverter(), new StringBufferConverter(), new StringBuilderConverter(), new TemporalConverter(), new ObjectWithFieldsConverter()};
    private final Map<Class<?>, ConfigurationConverter> lookupCache = Weak.concurrentKeys();
    private final List<ConfigurationConverter> customConverters = new CopyOnWriteArrayList<ConfigurationConverter>();

    @Override
    public void registerConverter(ConfigurationConverter converter) {
        this.customConverters.add(converter);
    }

    @Override
    public ConfigurationConverter lookupConverterForType(Class<?> type) throws ComponentConfigurationException {
        int i;
        ConfigurationConverter converter = this.lookupCache.get(type);
        if (null != converter) {
            return converter;
        }
        for (i = 0; i < this.customConverters.size(); ++i) {
            converter = this.customConverters.get(i);
            if (!converter.canConvert(type)) continue;
            this.lookupCache.put(type, converter);
            return converter;
        }
        for (i = 0; i < DEFAULT_CONVERTERS.length; ++i) {
            converter = DEFAULT_CONVERTERS[i];
            if (!converter.canConvert(type)) continue;
            this.lookupCache.put(type, converter);
            return converter;
        }
        throw new ComponentConfigurationException("Cannot find converter for type: " + type);
    }

    void setCustomConverters(List<ConfigurationConverter> converters) {
        this.customConverters.addAll(converters);
    }
}

