/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.eclipse.sisu.bean;

import shaded.com.google.inject.Binder;
import shaded.com.google.inject.Module;
import shaded.com.google.inject.TypeLiteral;
import shaded.com.google.inject.matcher.AbstractMatcher;
import shaded.com.google.inject.matcher.Matcher;
import shaded.com.google.inject.spi.InjectionListener;
import shaded.com.google.inject.spi.TypeEncounter;
import shaded.com.google.inject.spi.TypeListener;
import shaded.org.eclipse.sisu.bean.BeanManager;
import shaded.org.eclipse.sisu.bean.LifecycleManager;

public final class LifecycleModule
implements Module {
    private final Matcher<TypeLiteral<?>> matcher = new AbstractMatcher<TypeLiteral<?>>(){

        @Override
        public boolean matches(TypeLiteral<?> type) {
            return LifecycleModule.this.manager.manage(type.getRawType());
        }
    };
    private final TypeListener typeListener = new TypeListener(){
        private final InjectionListener<Object> listener = new InjectionListener<Object>(){

            @Override
            public void afterInjection(Object bean) {
                LifecycleModule.this.manager.manage(bean);
            }
        };

        public <B> void hear(TypeLiteral<B> type, TypeEncounter<B> encounter) {
            encounter.register(this.listener);
        }
    };
    final BeanManager manager;

    public LifecycleModule() {
        this(new LifecycleManager());
    }

    public LifecycleModule(BeanManager manager) {
        this.manager = manager;
    }

    @Override
    public void configure(Binder binder) {
        binder.bind(BeanManager.class).toInstance(this.manager);
        binder.bindListener(this.matcher, this.typeListener);
    }
}

