/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.eclipse.sisu.plexus;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import shaded.com.google.inject.Key;
import shaded.com.google.inject.ProvisionException;
import shaded.com.google.inject.TypeLiteral;
import shaded.com.google.inject.name.Names;
import shaded.org.codehaus.plexus.component.annotations.Component;
import shaded.org.codehaus.plexus.component.annotations.Requirement;
import shaded.org.eclipse.sisu.inject.TypeArguments;
import shaded.org.eclipse.sisu.plexus.Hints;

public final class Roles {
    private static final String MISSING_COMPONENT_ERROR = "No implementation for %s was bound.";
    private static final String MISSING_COMPONENT_WITH_HINT_ERROR = "No implementation for %s annotated with @Named(value=%s) was bound.";

    private Roles() {
    }

    public static String canonicalRoleHint(String role, String hint) {
        return Hints.isDefaultHint(hint) ? role : role + ':' + hint;
    }

    public static String canonicalRoleHint(Component component) {
        return Roles.canonicalRoleHint(component.role().getName(), component.hint());
    }

    public static TypeLiteral<?> roleType(Requirement requirement, TypeLiteral<?> asType) {
        Class<?> role = requirement.role();
        if (role != Object.class && role != Map.class && role != List.class) {
            return TypeLiteral.get(role);
        }
        Class<?> rawType = asType.getRawType();
        if (Map.class == rawType) {
            return TypeArguments.get(asType, 1);
        }
        if (List.class == rawType) {
            return TypeArguments.get(asType, 0);
        }
        return asType;
    }

    public static Key<?> componentKey(Component component) {
        return Roles.componentKey(component.role(), component.hint());
    }

    public static <T> Key<T> componentKey(Class<T> role, String hint) {
        if (Hints.isDefaultHint(hint)) {
            return Key.get(role);
        }
        return Key.get(role, (Annotation)Names.named(Hints.canonicalHint(hint)));
    }

    public static <T> Key<T> componentKey(TypeLiteral<T> role, String hint) {
        return Roles.componentKey(role.getRawType(), hint);
    }

    public static <T> T throwMissingComponentException(TypeLiteral<T> role, String hint) {
        if (Hints.isDefaultHint(hint)) {
            throw new ProvisionException(String.format(MISSING_COMPONENT_ERROR, role));
        }
        throw new ProvisionException(String.format(MISSING_COMPONENT_WITH_HINT_ERROR, role, hint));
    }

    public static String camelizeName(String name) {
        StringBuilder buf = null;
        int length = name.length();
        for (int i = 0; i < length; ++i) {
            if ('-' != name.charAt(i)) continue;
            buf = new StringBuilder(name.substring(0, i));
            break;
        }
        if (null == buf) {
            return name;
        }
        boolean capitalize = true;
        for (int i = buf.length() + 1; i < length; ++i) {
            char c = name.charAt(i);
            if ('-' == c) {
                capitalize = true;
                continue;
            }
            if (capitalize) {
                buf.append(Character.toTitleCase(c));
                capitalize = false;
                continue;
            }
            buf.append(c);
        }
        return buf.toString();
    }
}

