/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.eclipse.sisu.space;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.Enumeration;
import shaded.org.eclipse.sisu.inject.Logs;
import shaded.org.eclipse.sisu.space.AnnotationVisitor;
import shaded.org.eclipse.sisu.space.ClassFinder;
import shaded.org.eclipse.sisu.space.ClassSpace;
import shaded.org.eclipse.sisu.space.DefaultClassFinder;
import shaded.org.eclipse.sisu.space.SpaceVisitor;
import shaded.org.eclipse.sisu.space.Streams;
import shaded.org.eclipse.sisu.space.asm.ClassReader;
import shaded.org.eclipse.sisu.space.asm.ClassVisitor;
import shaded.org.eclipse.sisu.space.asm.Type;

public final class SpaceScanner {
    private static final int ASM_FLAGS = 7;
    static final ClassFinder DEFAULT_FINDER = new DefaultClassFinder();
    private final ClassSpace space;
    private final ClassFinder finder;
    private final boolean isStrict;

    public SpaceScanner(ClassSpace space, ClassFinder finder, boolean isStrict) {
        this.space = space;
        this.finder = finder;
        this.isStrict = isStrict;
    }

    @Deprecated
    public SpaceScanner(ClassSpace space, ClassFinder finder) {
        this(space, finder, false);
    }

    public SpaceScanner(ClassSpace space, boolean isStrict) {
        this(space, DEFAULT_FINDER, isStrict);
    }

    @Deprecated
    public SpaceScanner(ClassSpace space) {
        this(space, DEFAULT_FINDER);
    }

    public void accept(SpaceVisitor visitor) {
        visitor.enterSpace(this.space);
        Enumeration<URL> result = this.finder.findClasses(this.space);
        while (result.hasMoreElements()) {
            URL url = result.nextElement();
            shaded.org.eclipse.sisu.space.ClassVisitor cv = visitor.visitClass(url);
            if (null == cv) continue;
            SpaceScanner.accept(cv, url, this.isStrict);
        }
        visitor.leaveSpace();
    }

    @Deprecated
    public static void accept(shaded.org.eclipse.sisu.space.ClassVisitor visitor, URL url) {
        SpaceScanner.accept(visitor, url, false);
    }

    public static void accept(shaded.org.eclipse.sisu.space.ClassVisitor visitor, URL url, boolean isStrict) {
        if (null == url) {
            return;
        }
        try (InputStream in = Streams.open(url);){
            new ClassReader(in).accept(SpaceScanner.adapt(visitor), 7);
        }
        catch (IOException | RuntimeException e) {
            if (isStrict) {
                throw new IllegalStateException("Problem scanning " + url, e);
            }
            Logs.debug("Problem scanning: {}", url, e);
        }
    }

    public static String jvmDescriptor(Class<? extends Annotation> clazz) {
        return 'L' + clazz.getName().replace('.', '/') + ';';
    }

    private static ClassVisitor adapt(final shaded.org.eclipse.sisu.space.ClassVisitor _cv) {
        return null == _cv ? null : new ClassVisitor(589824){

            @Override
            public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                _cv.enterClass(access, name, superName, interfaces);
            }

            @Override
            public shaded.org.eclipse.sisu.space.asm.AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                final AnnotationVisitor _av = _cv.visitAnnotation(desc);
                return null == _av ? null : new shaded.org.eclipse.sisu.space.asm.AnnotationVisitor(589824){
                    {
                        super(api);
                        _av.enterAnnotation();
                    }

                    @Override
                    public void visit(String name, Object value) {
                        _av.visitElement(name, value instanceof Type ? ((Type)value).getClassName() : value);
                    }

                    @Override
                    public void visitEnd() {
                        _av.leaveAnnotation();
                    }
                };
            }

            @Override
            public void visitEnd() {
                _cv.leaveClass();
            }
        };
    }
}

