/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.eclipse.sisu.wire;

import java.lang.annotation.Annotation;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import shaded.com.google.inject.Binder;
import shaded.com.google.inject.Key;
import shaded.com.google.inject.Provider;
import shaded.com.google.inject.TypeLiteral;
import shaded.com.google.inject.name.Named;
import shaded.org.eclipse.sisu.BeanEntry;
import shaded.org.eclipse.sisu.inject.BeanLocator;
import shaded.org.eclipse.sisu.inject.TypeArguments;
import shaded.org.eclipse.sisu.wire.EntryListAdapter;
import shaded.org.eclipse.sisu.wire.EntryMapAdapter;
import shaded.org.eclipse.sisu.wire.EntrySetAdapter;
import shaded.org.eclipse.sisu.wire.NamedIterableAdapter;
import shaded.org.eclipse.sisu.wire.PlaceholderBeanProvider;
import shaded.org.eclipse.sisu.wire.ProviderIterableAdapter;

final class BeanProviders {
    final Provider<BeanLocator> locator;

    BeanProviders(Binder binder) {
        this.locator = binder.getProvider(BeanLocator.class);
    }

    public <K extends Annotation, V> Provider<Iterable<? extends BeanEntry<K, V>>> beanEntriesOf(final Key<V> key) {
        return new Provider<Iterable<? extends BeanEntry<K, V>>>(){

            @Override
            public Iterable<? extends BeanEntry<K, V>> get() {
                return BeanProviders.this.locator.get().locate(key);
            }
        };
    }

    public <K extends Annotation, V> Provider<Iterable<Map.Entry<K, V>>> entriesOf(Key key) {
        TypeLiteral type = key.getTypeLiteral();
        Class clazz = type.getRawType();
        if (shaded.javax.inject.Provider.class != clazz && Provider.class != clazz) {
            return this.beanEntriesOf(key);
        }
        final Provider<Iterable<BeanEntry<K, ?>>> beanEntries = this.beanEntriesOf(key.ofType(TypeArguments.get(type, 0)));
        return new Provider<Iterable<Map.Entry<K, V>>>(){

            @Override
            public Iterable<Map.Entry<K, V>> get() {
                return new ProviderIterableAdapter((Iterable)beanEntries.get());
            }
        };
    }

    public <K extends Annotation, V> Provider<List<V>> listOf(Key<V> key) {
        final Provider<Iterable<Map.Entry<K, V>>> entries = this.entriesOf(key);
        return new Provider<List<V>>(){

            @Override
            public List<V> get() {
                return new EntryListAdapter((Iterable)entries.get());
            }
        };
    }

    public <K extends Annotation, V> Provider<Set<V>> setOf(Key<V> key) {
        final Provider<Iterable<Map.Entry<K, V>>> entries = this.entriesOf(key);
        return new Provider<Set<V>>(){

            @Override
            public Set<V> get() {
                return new EntrySetAdapter((Iterable)entries.get());
            }
        };
    }

    public <K extends Annotation, V> Provider<Map<K, V>> mapOf(Key<V> key) {
        final Provider<Iterable<Map.Entry<K, V>>> entries = this.entriesOf(key);
        return new Provider<Map<K, V>>(){

            @Override
            public Map<K, V> get() {
                return new EntryMapAdapter((Iterable)entries.get());
            }
        };
    }

    public <V> Provider<Map<String, V>> stringMapOf(TypeLiteral<V> type) {
        final Provider entries = this.entriesOf(Key.get(type, Named.class));
        return new Provider<Map<String, V>>(){

            @Override
            public Map<String, V> get() {
                return new EntryMapAdapter(new NamedIterableAdapter((Iterable)entries.get()));
            }
        };
    }

    <V> Provider<V> firstOf(Key<V> key) {
        final Provider beanEntries = this.beanEntriesOf(key);
        return new Provider<V>(){
            private volatile Iterable<? extends BeanEntry<?, V>> cachedLookup;

            @Override
            public V get() {
                Iterator itr;
                if (null == this.cachedLookup) {
                    this.cachedLookup = (Iterable)beanEntries.get();
                }
                return (itr = this.cachedLookup.iterator()).hasNext() ? (Object)itr.next().getProvider().get() : null;
            }
        };
    }

    public <V> Provider<V> placeholderOf(Key<V> key) {
        return new PlaceholderBeanProvider<V>(this, key);
    }
}

