/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.jboss.shrinkwrap.resolver.impl.maven.bootstrap;

import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Properties;

final class SecurityActions {
    private SecurityActions() {
        throw new UnsupportedOperationException("No instantiation");
    }

    static String getProperty(String key) {
        try {
            String value = AccessController.doPrivileged(() -> System.getProperty(key));
            return value;
        }
        catch (PrivilegedActionException pae) {
            Throwable t = pae.getCause();
            if (t instanceof SecurityException) {
                throw (SecurityException)t;
            }
            if (t instanceof NullPointerException) {
                throw (NullPointerException)t;
            }
            if (t instanceof IllegalArgumentException) {
                throw (IllegalArgumentException)t;
            }
            try {
                throw (RuntimeException)t;
            }
            catch (ClassCastException cce) {
                throw new RuntimeException("Obtained unchecked Exception; this code should never be reached", t);
            }
        }
    }

    static String getEnvProperty(String key) {
        try {
            String value = AccessController.doPrivileged(() -> System.getenv(key));
            return value;
        }
        catch (PrivilegedActionException pae) {
            Throwable t = pae.getCause();
            if (t instanceof SecurityException) {
                throw (SecurityException)t;
            }
            if (t instanceof NullPointerException) {
                throw (NullPointerException)t;
            }
            if (t instanceof IllegalArgumentException) {
                throw (IllegalArgumentException)t;
            }
            try {
                throw (RuntimeException)t;
            }
            catch (ClassCastException cce) {
                throw new RuntimeException("Obtained unchecked Exception; this code should never be reached", t);
            }
        }
    }

    static Properties getProperties() {
        try {
            return AccessController.doPrivileged(System::getProperties);
        }
        catch (PrivilegedActionException pae) {
            Throwable t = pae.getCause();
            if (t instanceof SecurityException) {
                throw (SecurityException)t;
            }
            if (t instanceof NullPointerException) {
                throw (NullPointerException)t;
            }
            if (t instanceof IllegalArgumentException) {
                throw (IllegalArgumentException)t;
            }
            try {
                throw (RuntimeException)t;
            }
            catch (ClassCastException cce) {
                throw new RuntimeException("Obtained unchecked Exception; this code should never be reached", t);
            }
        }
    }

    static <T> T newInstance(Class<T> implClass, Class<?>[] argumentTypes, Object[] arguments) {
        T obj;
        if (implClass == null) {
            throw new IllegalArgumentException("ImplClass must be specified");
        }
        if (argumentTypes == null) {
            throw new IllegalArgumentException("ArgumentTypes must be specified. Use empty array if no arguments");
        }
        if (arguments == null) {
            throw new IllegalArgumentException("Arguments must be specified. Use empty array if no arguments");
        }
        try {
            Constructor<T> constructor = SecurityActions.getConstructor(implClass, argumentTypes);
            if (!constructor.isAccessible()) {
                constructor.setAccessible(true);
            }
            obj = constructor.newInstance(arguments);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create new instance of " + implClass, e);
        }
        return obj;
    }

    static <T> Constructor<T> getConstructor(Class<T> clazz, Class<?> ... argumentTypes) throws NoSuchMethodException {
        try {
            return AccessController.doPrivileged(() -> clazz.getDeclaredConstructor(argumentTypes));
        }
        catch (PrivilegedActionException pae) {
            Throwable t = pae.getCause();
            if (t instanceof NoSuchMethodException) {
                throw (NoSuchMethodException)t;
            }
            try {
                throw (RuntimeException)t;
            }
            catch (ClassCastException cce) {
                throw new RuntimeException("Obtained unchecked Exception; this code should never be reached", t);
            }
        }
    }
}

