/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.jboss.shrinkwrap.resolver.impl.maven.internal.decrypt;

import java.io.File;
import java.util.ArrayList;
import shaded.org.apache.maven.settings.Proxy;
import shaded.org.apache.maven.settings.Server;
import shaded.org.apache.maven.settings.building.DefaultSettingsProblem;
import shaded.org.apache.maven.settings.building.SettingsProblem;
import shaded.org.apache.maven.settings.crypto.SettingsDecrypter;
import shaded.org.apache.maven.settings.crypto.SettingsDecryptionRequest;
import shaded.org.apache.maven.settings.crypto.SettingsDecryptionResult;
import shaded.org.jboss.shrinkwrap.resolver.impl.maven.internal.decrypt.MavenSecurityDispatcher;
import shaded.org.jboss.shrinkwrap.resolver.impl.maven.internal.decrypt.MavenSettingsDecryptionResult;
import shaded.org.sonatype.plexus.components.sec.dispatcher.SecDispatcher;
import shaded.org.sonatype.plexus.components.sec.dispatcher.SecDispatcherException;

public class MavenSettingsDecrypter
implements SettingsDecrypter {
    private final SecDispatcher securityDispatcher;

    public MavenSettingsDecrypter(File securitySettings) {
        this.securityDispatcher = new MavenSecurityDispatcher(securitySettings);
    }

    @Override
    public SettingsDecryptionResult decrypt(SettingsDecryptionRequest request) {
        ArrayList<SettingsProblem> problems = new ArrayList<SettingsProblem>();
        ArrayList<Server> servers = new ArrayList<Server>();
        for (Server server : request.getServers()) {
            server = server.clone();
            servers.add(server);
            try {
                server.setPassword(this.decrypt(server.getPassword()));
            }
            catch (SecDispatcherException e) {
                problems.add(new DefaultSettingsProblem("Failed to decrypt password for server " + server.getId() + ": " + e.getMessage(), SettingsProblem.Severity.ERROR, "server: " + server.getId(), -1, -1, e));
            }
            try {
                server.setPassphrase(this.decrypt(server.getPassphrase()));
            }
            catch (SecDispatcherException e) {
                problems.add(new DefaultSettingsProblem("Failed to decrypt passphrase for server " + server.getId() + ": " + e.getMessage(), SettingsProblem.Severity.ERROR, "server: " + server.getId(), -1, -1, e));
            }
        }
        ArrayList<Proxy> proxies = new ArrayList<Proxy>();
        for (Proxy proxy : request.getProxies()) {
            proxy = proxy.clone();
            proxies.add(proxy);
            try {
                proxy.setPassword(this.decrypt(proxy.getPassword()));
            }
            catch (SecDispatcherException e) {
                problems.add(new DefaultSettingsProblem("Failed to decrypt password for proxy " + proxy.getId() + ": " + e.getMessage(), SettingsProblem.Severity.ERROR, "proxy: " + proxy.getId(), -1, -1, e));
            }
        }
        return new MavenSettingsDecryptionResult(servers, proxies, problems);
    }

    private String decrypt(String str) throws SecDispatcherException {
        return str == null ? null : this.securityDispatcher.decrypt(str);
    }
}

