/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.google.inject.spi;

import java.util.Set;
import shaded.com.google.common.base.Objects;
import shaded.com.google.common.base.Preconditions;
import shaded.com.google.inject.Binder;
import shaded.com.google.inject.ConfigurationException;
import shaded.com.google.inject.TypeLiteral;
import shaded.com.google.inject.spi.Element;
import shaded.com.google.inject.spi.ElementVisitor;
import shaded.com.google.inject.spi.InjectionPoint;

public final class InjectionRequest<T>
implements Element {
    private final Object source;
    private final TypeLiteral<T> type;
    private final T instance;

    public InjectionRequest(Object source, TypeLiteral<T> type, T instance) {
        this.source = Preconditions.checkNotNull(source, "source");
        this.type = Preconditions.checkNotNull(type, "type");
        this.instance = instance;
    }

    @Override
    public Object getSource() {
        return this.source;
    }

    public T getInstance() {
        return this.instance;
    }

    public TypeLiteral<T> getType() {
        return this.type;
    }

    public Set<InjectionPoint> getInjectionPoints() throws ConfigurationException {
        return InjectionPoint.forInstanceMethodsAndFields(this.type);
    }

    public <R> R acceptVisitor(ElementVisitor<R> visitor) {
        return visitor.visit(this);
    }

    @Override
    public void applyTo(Binder binder) {
        binder.withSource(this.getSource()).requestInjection(this.type, this.instance);
    }

    public boolean equals(Object obj) {
        return obj instanceof InjectionRequest && Objects.equal(((InjectionRequest)obj).instance, this.instance) && ((InjectionRequest)obj).type.equals(this.type) && ((InjectionRequest)obj).source.equals(this.source);
    }

    public int hashCode() {
        return Objects.hashCode(this.type, this.source);
    }
}

