/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.eclipse.sisu.plexus;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import shaded.com.google.inject.TypeLiteral;
import shaded.com.google.inject.name.Named;
import shaded.org.eclipse.sisu.BeanEntry;
import shaded.org.eclipse.sisu.plexus.LazyPlexusBean;
import shaded.org.eclipse.sisu.plexus.MissingPlexusBean;
import shaded.org.eclipse.sisu.plexus.PlexusBean;

final class HintedPlexusBeans<T>
implements Iterable<PlexusBean<T>> {
    private final Iterable<BeanEntry<Named, T>> beans;
    private final List<PlexusBean<T>> missingPlexusBeans;

    HintedPlexusBeans(Iterable<BeanEntry<Named, T>> beans, TypeLiteral<T> role, String[] hints) {
        this.beans = beans;
        this.missingPlexusBeans = new ArrayList<PlexusBean<T>>(hints.length);
        for (String h : hints) {
            this.missingPlexusBeans.add(new MissingPlexusBean<T>(role, h));
        }
    }

    @Override
    public Iterator<PlexusBean<T>> iterator() {
        ArrayList<PlexusBean<T>> plexusBeans = new ArrayList<PlexusBean<T>>(this.missingPlexusBeans);
        int size = plexusBeans.size();
        Iterator<BeanEntry<Named, T>> itr = this.beans.iterator();
        int numFound = 0;
        while (numFound < size && itr.hasNext()) {
            BeanEntry<Named, T> candidate = itr.next();
            String hint = ((Named)candidate.getKey()).value();
            for (int i = 0; i < size; ++i) {
                PlexusBean element = (PlexusBean)plexusBeans.get(i);
                if (!(element instanceof MissingPlexusBean) || !hint.equals(element.getKey())) continue;
                plexusBeans.set(i, new LazyPlexusBean<T>(candidate));
                ++numFound;
            }
        }
        return plexusBeans.iterator();
    }
}

