/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.eclipse.sisu.plexus;

import java.util.Map;
import shaded.com.google.inject.Binder;
import shaded.com.google.inject.Module;
import shaded.org.codehaus.plexus.component.annotations.Component;
import shaded.org.eclipse.sisu.plexus.PlexusAnnotatedMetadata;
import shaded.org.eclipse.sisu.plexus.PlexusBeanMetadata;
import shaded.org.eclipse.sisu.plexus.PlexusBeanModule;
import shaded.org.eclipse.sisu.plexus.PlexusBeanSource;
import shaded.org.eclipse.sisu.plexus.PlexusTypeBinder;
import shaded.org.eclipse.sisu.plexus.PlexusTypeVisitor;
import shaded.org.eclipse.sisu.space.BeanScanning;
import shaded.org.eclipse.sisu.space.ClassSpace;
import shaded.org.eclipse.sisu.space.SpaceModule;
import shaded.org.eclipse.sisu.space.SpaceVisitor;

public final class PlexusAnnotatedBeanModule
implements PlexusBeanModule {
    private static final SpaceModule.Strategy PLEXUS_STRATEGY = new SpaceModule.Strategy(){

        @Override
        public SpaceVisitor visitor(Binder binder) {
            return new PlexusTypeVisitor(new PlexusTypeBinder(binder));
        }
    };
    private Module spaceModule;
    private final PlexusBeanSource beanSource;

    public PlexusAnnotatedBeanModule(ClassSpace space, Map<?, ?> variables) {
        this(space, variables, BeanScanning.ON);
    }

    @Deprecated
    public PlexusAnnotatedBeanModule(ClassSpace space, Map<?, ?> variables, BeanScanning scanning) {
        this(space, variables, scanning, false);
    }

    public PlexusAnnotatedBeanModule(ClassSpace space, Map<?, ?> variables, BeanScanning scanning, boolean strictScanning) {
        this.spaceModule = null != space && scanning != BeanScanning.OFF ? new SpaceModule(space, scanning, strictScanning).with(PLEXUS_STRATEGY) : null;
        this.beanSource = new PlexusAnnotatedBeanSource(variables);
    }

    public PlexusBeanModule with(SpaceModule.Strategy _strategy) {
        if (this.spaceModule instanceof SpaceModule) {
            this.spaceModule = ((SpaceModule)this.spaceModule).with(_strategy);
        }
        return this;
    }

    @Override
    public PlexusBeanSource configure(Binder binder) {
        if (null != this.spaceModule) {
            this.spaceModule.configure(binder);
        }
        return this.beanSource;
    }

    private static final class PlexusAnnotatedBeanSource
    implements PlexusBeanSource {
        private final PlexusBeanMetadata metadata;

        PlexusAnnotatedBeanSource(Map<?, ?> variables) {
            this.metadata = new PlexusAnnotatedMetadata(variables);
        }

        @Override
        public PlexusBeanMetadata getBeanMetadata(Class<?> implementation) {
            return implementation.isAnnotationPresent(Component.class) ? this.metadata : null;
        }
    }
}

