/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.jboss.shrinkwrap.resolver.impl.maven;

import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import shaded.org.apache.maven.settings.Settings;
import shaded.org.eclipse.aether.DefaultRepositorySystemSession;
import shaded.org.jboss.shrinkwrap.resolver.api.InvalidConfigurationFileException;
import shaded.org.jboss.shrinkwrap.resolver.api.maven.MavenWorkingSession;
import shaded.org.jboss.shrinkwrap.resolver.impl.maven.SettingsManager;
import shaded.org.jboss.shrinkwrap.resolver.impl.maven.bootstrap.MavenRepositorySystem;

public abstract class ConfigurableMavenWorkingSessionImpl
implements MavenWorkingSession {
    private static final Logger log = Logger.getLogger(ConfigurableMavenWorkingSessionImpl.class.getName());
    private DefaultRepositorySystemSession session;
    private final SettingsManager settingsManager;
    private boolean useLegacyLocalRepository = false;
    private final MavenRepositorySystem system = new MavenRepositorySystem();
    private boolean disableClassPathWorkspaceReader = false;
    private boolean skipCompilation = false;

    public ConfigurableMavenWorkingSessionImpl() {
        this.settingsManager = new SettingsManager();
    }

    @Override
    public MavenWorkingSession configureSettingsFromFile(File globalSettings, File userSettings) throws InvalidConfigurationFileException {
        this.settingsManager.configureSettingsFromFile(globalSettings, userSettings);
        return this.regenerateSession();
    }

    @Override
    public MavenWorkingSession regenerateSession() {
        this.generateSession();
        return this;
    }

    @Override
    public void setOffline(boolean offline) {
        if (log.isLoggable(Level.FINER)) {
            log.finer("Set offline mode programmatically to: " + offline);
        }
        this.settingsManager.setOffline(offline);
    }

    @Override
    public void disableClassPathWorkspaceReader() {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Disabling ClassPath resolution");
        }
        this.disableClassPathWorkspaceReader = true;
    }

    @Override
    public void useLegacyLocalRepository(boolean useLegacyLocalRepository) {
        if (this.useLegacyLocalRepository == useLegacyLocalRepository) {
            return;
        }
        log.log(Level.FINEST, "Using legacy local repository");
        this.useLegacyLocalRepository = useLegacyLocalRepository;
    }

    @Override
    public boolean skipCompilation() {
        return this.skipCompilation;
    }

    @Override
    public void skipCompilation(boolean skip) {
        this.skipCompilation = skip;
    }

    protected DefaultRepositorySystemSession getSession() {
        if (this.session == null) {
            this.generateSession();
        }
        return this.session;
    }

    protected Settings getSettings() {
        return this.settingsManager.getSettings();
    }

    protected boolean isOffline() {
        return this.settingsManager.isOffline();
    }

    protected MavenRepositorySystem getSystem() {
        return this.system;
    }

    private void regenerateSessionIfNotNull() {
        if (this.session != null) {
            this.regenerateSession();
        }
    }

    private void generateSession() {
        this.session = this.system.getSession(this.getSettings(), this.useLegacyLocalRepository);
        if (this.disableClassPathWorkspaceReader) {
            this.session.setWorkspaceReader(null);
        }
    }
}

