/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.jboss.shrinkwrap.resolver.impl.maven;

import java.io.File;
import shaded.org.apache.maven.settings.Settings;
import shaded.org.apache.maven.settings.building.DefaultSettingsBuildingRequest;
import shaded.org.jboss.shrinkwrap.resolver.api.InvalidConfigurationFileException;
import shaded.org.jboss.shrinkwrap.resolver.impl.maven.SecurityActions;
import shaded.org.jboss.shrinkwrap.resolver.impl.maven.bootstrap.MavenSettingsBuilder;

public class SettingsManager {
    private Settings settings;
    private Boolean programmaticOffline;

    public void configureSettingsFromFile(File globalSettings, File userSettings) throws InvalidConfigurationFileException {
        DefaultSettingsBuildingRequest request = new DefaultSettingsBuildingRequest();
        if (globalSettings != null) {
            request.setGlobalSettingsFile(globalSettings);
        }
        if (userSettings != null) {
            request.setUserSettingsFile(userSettings);
        }
        request.setSystemProperties(SecurityActions.getProperties());
        MavenSettingsBuilder builder = new MavenSettingsBuilder();
        this.settings = builder.buildSettings(request);
        this.propagateProgrammaticOfflineIntoSettings();
    }

    protected Settings getSettings() {
        if (this.settings == null) {
            this.settings = new MavenSettingsBuilder().buildDefaultSettings();
            this.propagateProgrammaticOfflineIntoSettings();
        }
        return this.settings;
    }

    protected void setOffline(Boolean programmaticOffline) {
        this.programmaticOffline = programmaticOffline;
        this.propagateProgrammaticOfflineIntoSettings();
    }

    protected boolean isOffline() {
        if (this.programmaticOffline != null) {
            return this.programmaticOffline;
        }
        return this.getSettings().isOffline();
    }

    private void propagateProgrammaticOfflineIntoSettings() {
        if (this.programmaticOffline != null && this.settings != null) {
            this.settings.setOffline(this.programmaticOffline);
        }
    }
}

