/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.KeyValueHolder;
import java.util.Objects;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface Map<K, V> {
    public int size();

    public boolean isEmpty();

    public boolean containsKey(Object var1);

    public boolean containsValue(Object var1);

    public V get(Object var1);

    public V put(K var1, V var2);

    public V remove(Object var1);

    public void putAll(Map<? extends K, ? extends V> var1);

    public void clear();

    public Set<K> keySet();

    public Collection<V> values();

    public Set<Entry<K, V>> entrySet();

    public boolean equals(Object var1);

    public int hashCode();

    public static interface Entry<K, V> {
        public K getKey();

        public V getValue();

        public V setValue(V var1);

        public boolean equals(Object var1);

        public int hashCode();

        public static <K extends Comparable<? super K>, V> Comparator<Entry<K, V>> comparingByKey() {
            return (Comparator & Serializable)(c1, c2) -> ((Comparable)c1.getKey()).compareTo(c2.getKey());
        }

        public static <K, V extends Comparable<? super V>> Comparator<Entry<K, V>> comparingByValue() {
            return (Comparator & Serializable)(c1, c2) -> ((Comparable)c1.getValue()).compareTo(c2.getValue());
        }

        public static <K, V> Comparator<Entry<K, V>> comparingByKey(Comparator<? super K> cmp) {
            Objects.requireNonNull(cmp);
            return (Comparator & Serializable)(c1, c2) -> cmp.compare((Object)c1.getKey(), (Object)c2.getKey());
        }

        public static <K, V> Comparator<Entry<K, V>> comparingByValue(Comparator<? super V> cmp) {
            Objects.requireNonNull(cmp);
            return (Comparator & Serializable)(c1, c2) -> cmp.compare((Object)c1.getValue(), (Object)c2.getValue());
        }

        public static <K, V> Entry<K, V> copyOf(Entry<? extends K, ? extends V> e) {
            Objects.requireNonNull(e);
            if (e instanceof KeyValueHolder) {
                return e;
            }
            return Map.entry(e.getKey(), e.getValue());
        }
    }
}

